% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findRscript.R
\name{findRscript}
\alias{findRscript}
\title{Find R scripts by content with pattern matching}
\usage{
findRscript(pattern = "Hello World", path = ".", case.sensitive = TRUE,
  comments = TRUE, show.results = TRUE, copy = FALSE,
  folder = "findRscript", overwrite = TRUE)
}
\arguments{
\item{pattern}{a pattern (regular expression) to search for.}

\item{path}{a character vector, path to be scanned. The default corresponds to the working directory, getwd().}

\item{case.sensitive}{a logical value. If \code{TRUE}, pattern-matching is case-sensitive.}

\item{comments}{a logical value. If \code{TRUE}, comments (lines starting with #) are included in the pattern-matching procedure.}

\item{show.results}{a logical value. If \code{TRUE}, results are printed after completion.}

\item{copy}{a logical value. If \code{TRUE}, all matching R scripts are copied to \code{folder}.}

\item{folder}{a character vector, path or name of new folder to copy matching R scripts to.}

\item{overwrite}{a logical value. If \code{TRUE}, existing destination files are overwritten.}
}
\description{
\code{findRscript} scans all directories and subdirectories of a given path for R scripts (.R) containing
    a specific pattern.  Hits can be copied to a new folder.
}
\examples{
# Find all Rscripts in the package folder that use the circlize package
findRscript(path = system.file(package = "findR"), pattern = "circlize")

# Save results in a data frame and show hits
dt <- findRscript(path = system.file(package = "findR"), pattern = "circlize", show.results = TRUE)
dt

}
