% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findviews_to_compare.R
\name{findviews_to_compare}
\alias{findviews_to_compare}
\title{Views of a multidimensional dataset, ranked by their differentiation power.}
\usage{
findviews_to_compare(group1, group2, data, view_size_max = NULL,
  clust_method = "complete", ...)
}
\arguments{
\item{group1}{Logical vector of size \code{nrow(data)}, which describes the
first group to compare. The value \code{TRUE} at position i indicates the
the i-th row of \code{data} belongs to the group.}

\item{group2}{Logical vector, which describes the second group to compare.
The value \code{TRUE} at position i indicates the the i-th row of
\code{data} belongs to the group.}

\item{data}{Data frame or matrix to be processed}

\item{view_size_max}{Maximum number of columns in the views. If set to
\code{NULL}, findviews uses \code{log2(ncol(data))}, rounded upwards and
capped at 5.}

\item{clust_method}{Character describing a clustering method, used internally
by \code{\link[stats]{hclust}}. Example values are "complete", "single" or
"average".}

\item{...}{Optional Shiny parameters, used in Shiny's
\code{\link[shiny]{runApp}} function.}
}
\description{
\code{findviews_to_compare} detects views on which two arbitrary sets
of rows differ. It plots the results with ggplot and Shiny.
}
\details{
The function \code{findviews_to_compare} takes two groups of rows as input
and detects views on which the statistical distribution of those two groups
differ.

To detect the set of views, \code{findviews_to_compare} eliminates
the rows which are present in neither group and applies \code{\link{findviews}}.

To evaluate the differentiation power of the views, findviews computes the
histograms of the two groups to be compared, and computes their dissimilarity
them with the Euclidean distance.

This method is loosely based on the following paper: \preformatted{
Fast, Explainable View Detection to Characterize Exploration Queries
Thibault Sellam, Martin Kersten
SSDBM, 2016}
}
\examples{
\dontrun{
findviews_to_compare(mtcars$mpg >= 20 , mtcars$mpg < 20 , mtcars)
}

}

