% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findviews_to_compare.R
\name{findviews_to_compare_core}
\alias{findviews_to_compare_core}
\title{Views of a multidimensional dataset, ranked by their differentiation power,
non-Shiny version}
\usage{
findviews_to_compare_core(group1, group2, data, view_size_max = NULL,
  clust_method = "complete")
}
\arguments{
\item{group1}{Logical vector of size \code{nrow(data)}, which describes the
first group to compare. The value \code{TRUE} at position i indicates the
the i-th row of \code{data} belongs to the group.}

\item{group2}{Logical vector, which describes the second group to compare.
The value \code{TRUE} at position i indicates the the i-th row of
\code{data} belongs to the group.}

\item{data}{Data frame or matrix to be processed}

\item{view_size_max}{Maximum number of columns in the views. If set to
\code{NULL}, findviews uses \code{log2(ncol(data))}, rounded upwards and
capped at 5.}

\item{clust_method}{Character describing a clustering method, used internally
by \code{\link[stats]{hclust}}. Example values are "complete", "single" or
"average".}
}
\description{
\code{findviews_to_compare_core} detects views on which two arbitrary sets of
tuples are well separated. It produces the same
results as \code{\link{findviews_to_compare}}, but does \emph{not}
present them with a Shiny app.
}
\details{
The function \code{findviews_to_compare_core} takes two groups of tuples as
input, and detects views on which the statistical distribution of those two
groups is different. See the documentation of
\code{\link{findviews_to_compare}} for more details.

The  difference between \code{\link{findviews_to_compare}} and
\code{\link{findviews_to_compare_core}} is that the former presents
its results with a Shiny app, while the latter simply outputs them as R
stuctures.
}
\examples{
findviews_to_compare_core(mtcars$mpg >= 20 , mtcars$mpg < 20 , mtcars)

}

