% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprivation_decile.R
\name{deprivation_decile}
\alias{deprivation_decile}
\title{Deprivation deciles}
\usage{
deprivation_decile(AreaTypeID = 102, Year = 2015)
}
\arguments{
\item{AreaTypeID}{Numeric value, limited to either 102 (counties and unitary
authorities) or 101 (local authority districts and unitary authorities); default is 102}

\item{Year}{Numeric value, representing the year of IMD release to be applied, limited to either 2010 or 2015; default is 2015}
}
\value{
A lookup table providing deprivation decile and area code
}
\description{
Outputs a data frame allocating deprivation decile to  area code base on the Indices of Multiple Deprivation (IMD) produced by Department of Communities and Local Government
}
\examples{
# Return 2015 deciles for counties and unitary authorities
deprivation_decile()

# Return 2010 deciles for local authority districts and unitary authorities
deprivation_decile(101, 2010)
}
\seealso{
\code{\link{indicators}} for indicator lookups,
  \code{\link{profiles}} for profile lookups
  \code{\link{indicator_metadata}} for the metadata for each indicator and
  \code{\link{area_types}} for area types and their parent mappings and
  \code{\link{category_types}} for category lookups and
  \code{\link{indicator_areatypes}} for indicators by area types lookups

Other lookup functions: \code{\link{area_types}},
  \code{\link{category_types}},
  \code{\link{indicator_areatypes}},
  \code{\link{indicator_metadata}},
  \code{\link{indicators}}, \code{\link{profiles}}
}
