% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finnishgrid.R
\name{transmission_FI_to_SE3_RTD}
\alias{transmission_FI_to_SE3_RTD}
\title{Transmission between Finland and Central Sweden - real time data}
\usage{
transmission_FI_to_SE3_RTD(start_time = NA, end_time = NA, user_key = NA)
}
\arguments{
\item{start_time}{Start time in UTC with offset. Character array in ISO8601,
YYYY-MM-ddTHH:mm:ssZ}

\item{end_time}{End time in UTC with offset. Character array in ISO8601,
YYYY-MM-ddTHH:mm:ssZ}

\item{user_key}{Character array holding API-key.
Free from https://data.fingrid.fi/open-data-forms/registration/}
}
\value{
A data frame object that contains power transmission between
Central Sweden (SE3) and Finland (FI) HVDC tie lines. Data is based on
the real-time measurements in Fingrid's operation control system.
Positive sign means transmission from Finland to Central Sweden (SE3).
Negative sign means transmission from Central Sweden (SE3) to Finland.
The data is updated every 3 minutes.
}
\description{
Check https://data.fingrid.fi/en/dataset/transmission-between-finland-and-central-sweden-real-time-data
}
\examples{
\dontrun{
library(finnishgrid)
start = "2021-01-01T00:00:00+0200"  # UTC+2 offset, Helsinki time
end = "2021-01-10T00:00:00+0200"    # UTC+2 offset, Helsinki time
key = "MY_SUPER_SECRET"
df <- transmission_FI_to_SE3_RTD(start_time = start,
    end_time = end,
    user_key = key)
summary(df)
}
}
