% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-email-password.R
\name{FirebaseEmailPassword}
\alias{FirebaseEmailPassword}
\title{Email & Password}
\description{
Manage users using email and password.
}
\note{
Also signs in the user if successful.
}
\examples{
library(shiny)
library(firebase)

# modals
register <- modalDialog(
  title = "Register",
  textInput("email_create", "Your email"),
  passwordInput("password_create", "Your password"),
  footer = actionButton("create", "Register")
)

sign_in <- modalDialog(
  title = "Sign in",
  textInput("email_signin", "Your email"),
  passwordInput("password_signin", "Your password"),
  footer = actionButton("signin", "Sign in")
)

ui <- fluidPage(
  useFirebase(), # import dependencies
  actionButton("register_modal", "Register"),
  actionButton("signin_modal", "Signin"),
  plotOutput("plot")
)

server <- function(input, output){

  f <- FirebaseEmailPassword$new()

  # open modals
  observeEvent(input$register_modal, {
    showModal(register)
  })

  observeEvent(input$signin_modal, {
    showModal(sign_in)
  })

  # create the user
  observeEvent(input$create, {
    f$create(input$email_create, input$password_create)
  })

  # check if creation sucessful
  observeEvent(f$get_created(), {
    created <- f$get_created()
    
    if(created$success){
      removeModal()
      showNotification("Account created!", type = "message")
    } else {
      showNotification("Error!", type = "error")
    }

    # print results to the console
    print(created)
  })

  observeEvent(input$signin, {
    removeModal()
    f$sign_in(input$email_signin, input$password_signin)
  })

  output$plot <- renderPlot({
    f$req_sign_in()
    plot(cars)
  })

}

\dontrun{shinyApp(ui, server)}

}
\section{Super class}{
\code{\link[firebase:Firebase]{firebase::Firebase}} -> \code{FirebaseEmailPassword}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{created}}{Results of account creation}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-create}{\code{FirebaseEmailPassword$create()}}
\item \href{#method-sign_in}{\code{FirebaseEmailPassword$sign_in()}}
\item \href{#method-get_created}{\code{FirebaseEmailPassword$get_created()}}
\item \href{#method-reset_password}{\code{FirebaseEmailPassword$reset_password()}}
\item \href{#method-get_reset}{\code{FirebaseEmailPassword$get_reset()}}
\item \href{#method-send_verification_email}{\code{FirebaseEmailPassword$send_verification_email()}}
\item \href{#method-get_verification_email}{\code{FirebaseEmailPassword$get_verification_email()}}
\item \href{#method-set_password}{\code{FirebaseEmailPassword$set_password()}}
\item \href{#method-get_password}{\code{FirebaseEmailPassword$get_password()}}
\item \href{#method-re_authenticate}{\code{FirebaseEmailPassword$re_authenticate()}}
\item \href{#method-get_re_authenticated}{\code{FirebaseEmailPassword$get_re_authenticated()}}
\item \href{#method-clone}{\code{FirebaseEmailPassword$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="firebase" data-topic="Firebase" data-id="clear">}\href{../../firebase/html/Firebase.html#method-clear}{\code{firebase::Firebase$clear()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="firebase" data-topic="Firebase" data-id="delete_user">}\href{../../firebase/html/Firebase.html#method-delete_user}{\code{firebase::Firebase$delete_user()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="firebase" data-topic="Firebase" data-id="get_access_token">}\href{../../firebase/html/Firebase.html#method-get_access_token}{\code{firebase::Firebase$get_access_token()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="firebase" data-topic="Firebase" data-id="get_delete_user">}\href{../../firebase/html/Firebase.html#method-get_delete_user}{\code{firebase::Firebase$get_delete_user()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="firebase" data-topic="Firebase" data-id="get_id_token">}\href{../../firebase/html/Firebase.html#method-get_id_token}{\code{firebase::Firebase$get_id_token()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="firebase" data-topic="Firebase" data-id="get_sign_out">}\href{../../firebase/html/Firebase.html#method-get_sign_out}{\code{firebase::Firebase$get_sign_out()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="firebase" data-topic="Firebase" data-id="get_signed_in">}\href{../../firebase/html/Firebase.html#method-get_signed_in}{\code{firebase::Firebase$get_signed_in()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="firebase" data-topic="Firebase" data-id="get_signed_up">}\href{../../firebase/html/Firebase.html#method-get_signed_up}{\code{firebase::Firebase$get_signed_up()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="firebase" data-topic="Firebase" data-id="initialize">}\href{../../firebase/html/Firebase.html#method-initialize}{\code{firebase::Firebase$initialize()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="firebase" data-topic="Firebase" data-id="is_signed_in">}\href{../../firebase/html/Firebase.html#method-is_signed_in}{\code{firebase::Firebase$is_signed_in()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="firebase" data-topic="Firebase" data-id="print">}\href{../../firebase/html/Firebase.html#method-print}{\code{firebase::Firebase$print()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="firebase" data-topic="Firebase" data-id="req_sign_in">}\href{../../firebase/html/Firebase.html#method-req_sign_in}{\code{firebase::Firebase$req_sign_in()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="firebase" data-topic="Firebase" data-id="req_sign_out">}\href{../../firebase/html/Firebase.html#method-req_sign_out}{\code{firebase::Firebase$req_sign_out()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="firebase" data-topic="Firebase" data-id="request_id_token">}\href{../../firebase/html/Firebase.html#method-request_id_token}{\code{firebase::Firebase$request_id_token()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="firebase" data-topic="Firebase" data-id="set_language_code">}\href{../../firebase/html/Firebase.html#method-set_language_code}{\code{firebase::Firebase$set_language_code()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="firebase" data-topic="Firebase" data-id="sign_out">}\href{../../firebase/html/Firebase.html#method-sign_out}{\code{firebase::Firebase$sign_out()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-create"></a>}}
\if{latex}{\out{\hypertarget{method-create}{}}}
\subsection{Method \code{create()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FirebaseEmailPassword$create(email, password)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{email, password}}{Credentials as entered by the user.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Create an account
}

\subsection{Returns}{
self
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-sign_in"></a>}}
\if{latex}{\out{\hypertarget{method-sign_in}{}}}
\subsection{Method \code{sign_in()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FirebaseEmailPassword$sign_in(email, password)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{email, password}}{Credentials as entered by the user.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Sign in with email
}

\subsection{Returns}{
\code{NULL} if successful, the error otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_created"></a>}}
\if{latex}{\out{\hypertarget{method-get_created}{}}}
\subsection{Method \code{get_created()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FirebaseEmailPassword$get_created()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Get account creation results
}

\subsection{Returns}{
A list of length 2 containing \code{success} a boolean
indicating wherther creation was successful and \code{response}
containing the result of account creation or the error if failed.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-reset_password"></a>}}
\if{latex}{\out{\hypertarget{method-reset_password}{}}}
\subsection{Method \code{reset_password()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FirebaseEmailPassword$reset_password(email = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{email}}{Email to send reset link to, if missing looks for current logged in user's email.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Reset user password
}

\subsection{Returns}{
self
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_reset"></a>}}
\if{latex}{\out{\hypertarget{method-get_reset}{}}}
\subsection{Method \code{get_reset()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FirebaseEmailPassword$get_reset()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Get whether password reset email was successfully sent
}

\subsection{Returns}{
A list of length 2 containing \code{success} a boolean
indicating whether email reset was successful and \code{response}
containing \code{successful} or the error.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-send_verification_email"></a>}}
\if{latex}{\out{\hypertarget{method-send_verification_email}{}}}
\subsection{Method \code{send_verification_email()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FirebaseEmailPassword$send_verification_email()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Send the user a verification email
}

\subsection{Returns}{
self
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_verification_email"></a>}}
\if{latex}{\out{\hypertarget{method-get_verification_email}{}}}
\subsection{Method \code{get_verification_email()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FirebaseEmailPassword$get_verification_email()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Get result of verification email sending procedure
}

\subsection{Returns}{
A list of length 2 containing \code{success} a boolean
indicating whether email verification was successfully sent and \code{response}
containing \code{successful} or the error.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_password"></a>}}
\if{latex}{\out{\hypertarget{method-set_password}{}}}
\subsection{Method \code{set_password()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FirebaseEmailPassword$set_password(password)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{password}}{The authenticated user password, the user should be prompted
to enter it.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Set user password

Useful to provide ability to change password.
}

\subsection{Returns}{
self
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_password"></a>}}
\if{latex}{\out{\hypertarget{method-get_password}{}}}
\subsection{Method \code{get_password()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FirebaseEmailPassword$get_password()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Get response from set_password
}

\subsection{Returns}{
A list of length 2 containing \code{success} a boolean
indicating whether setting password was successfully set and \code{response}
containing \code{successful} as string or the error.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-re_authenticate"></a>}}
\if{latex}{\out{\hypertarget{method-re_authenticate}{}}}
\subsection{Method \code{re_authenticate()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FirebaseEmailPassword$re_authenticate(password)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{password}}{The authenticated user password, the user should be prompted
to enter it.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Re-authenticate the user.

Some security-sensitive actions—such as deleting an account, setting a
primary email address, and changing a password—require that the user has
recently signed in. If you perform one of these actions, and the user signed
in too long ago, the action fails with an error.
}

\subsection{Returns}{
self
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_re_authenticated"></a>}}
\if{latex}{\out{\hypertarget{method-get_re_authenticated}{}}}
\subsection{Method \code{get_re_authenticated()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FirebaseEmailPassword$get_re_authenticated()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Get response from re_authenticate
}

\subsection{Returns}{
A list of length 2 containing \code{success} a boolean
indicating whether re-authentication was successful and \code{response}
containing \code{successful} as string or the error.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FirebaseEmailPassword$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
