% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/limitation.R
\name{limitation}
\alias{limitation}
\title{A function to evaluate element limitation of the model}
\usage{
limitation(mod, plot = TRUE)
}
\arguments{
\item{mod}{Model output from cnp_model_mcmc().}

\item{plot}{Argument to specify if results should be shown in a plot.}
}
\description{
This function allows you extract the proportions of the iterations for which c, n and p are the limiting element in the model.
}
\details{
Returns a data frame with:
\describe{
  \item{tl}{Total length, in cm}
  \item{nutrient}{c, n or p}
  \item{prop_lim}{the proportion of iterations for which there is limitation by the element}
}
}
\examples{
library(fishflux)
mod <- cnp_model_mcmc(TL = 5, param = list(Qc_m = 40, Qn_m = 10, Qp_m = 4,
                                           Dc_sd = 0.1, Dn_sd = 0.05, Dp_sd = 0.05))
limitation(mod)

}
\keyword{fish}
\keyword{limitation}
\keyword{plot}
