% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimulateBOD.R
\name{GenerateBOD}
\alias{GenerateBOD}
\title{Generate Overdispersed Binomial Outcome Data}
\usage{
GenerateBOD(N,n,pi,rho)
}
\arguments{
\item{N}{single value for number of total frequencies}

\item{n}{single value for binomial random variable}

\item{pi}{single value for probability of success}

\item{rho}{single value for overdispersion parameter}
}
\value{
The output of \code{GenerateBOD} gives a vector of overdispersed binomial random variables
}
\description{
Using a three step algorithm to generate overdispersed binomial outcome data.
When the number of frequencies, binomial random variable, probability of success and overdispersion
are given.
}
\details{
The generated binomial random variables are overdispersed based on \eqn{rho} for the probability of
success \eqn{pi}.

Step 1: Solve the following equation for a given \eqn{n,pi,rho},
\deqn{phi(z(pi),z(pi),delta)=pi(1-pi)rho + pi^2,}

For \eqn{delta} where \eqn{phi(z(pi),z(pi),delta)} is the cumulative distribution function of the
standard bivariate normal random variable with correlation coefficient \eqn{delta}, and \eqn{z(pi)} denotes
the \eqn{pi^{th}} quantile of the standard normal distribution.

Step 2: Generate $n$-dimensional multivariate normal random variables, \eqn{Z_i=(Z_{i1},Z_{i2},ldots,Z_{in})^T}
with mean \eqn{0} and constant correlation matrix \eqn{Sigma_i} for \eqn{i=1,2,\ldots,N,} where the elements of
\eqn{(Sigma_i)_{lm}} are \eqn{delta} for \eqn{l \ne m}.

Step 3: Now for each \eqn{j=1,2,\ldots,n} define \eqn{X_{ij} = 1;} if \eqn{Z_{ij} < z(\pi)}, or
\eqn{X_{ij} = 0;} otherwise. Then, it can be showed that the random variable \eqn{Y_i=\sum_{j=1}^{n} X_{ij}}
is overdispersed relative to the Binomial distribution.

\strong{NOTE} : If input parameters are not in given domain conditions necessary error
messages will be provided to go further.
}
\examples{
N <- 500    # Number of observations
n <- 10      # Dimension of multivariate normal random variables
pi <- 0.5   # Probability threshold
rho <- 0.1  # Dispersion parameter

# Generate overdispersed binomial variables
New_overdispersed_data <- GenerateBOD(N, n, pi, rho)
table(New_overdispersed_data)

}
\references{
\insertRef{manoj2013mcdonald}{fitODBOD}
}
