% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Data.R
\docType{data}
\name{Exam_data}
\alias{Exam_data}
\title{Exam Data}
\format{
A data frame with 2 columns and 10 rows
\describe{
\item{\code{No.of.alpha}}{No of Alphas}
\item{\code{fre}}{Observed frequencies}
}
}
\source{
Extracted from

Paul, S.R., 1985. A three-parameter generalization of the binomial distribution. Communications in
Statistics - Theory and Methods, 14(6), pp.1497-1506.

Available at: \doi{10.1080/03610928508828990}
}
\usage{
Exam_data
}
\description{
In an examination, there were 9 questions set on a particular
topic. Each question is marked out of a total of 20 and in assessing the
final class of a candidate, particular attention is paid to the total
number of questions for which he has an "alpha", i.e., at least 15 out of 20,
as well as his total number of marks. His number of alpha's is a rough
indication of the "quality" of his exam performance. Thus, the distribution
of alpha's over the candidates is of interest. There were 209 candidates
attempting questions from this section of 9 questions and a total of 326 alpha's
was awarded. So we treat 9 as the "litter size", and the dichotomous response
is whether or not he got an alpha on the question.
}
\examples{
Exam_data$No.of.alpha              #extracting the binomial random variables
sum(Exam_data$fre)                 #summing all the frequencies

}
\keyword{datasets}
