% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/110b_gev_libs.R
\name{dgevsub}
\alias{dgevsub}
\title{Densities for 5 predictions}
\usage{
dgevsub(
  x,
  y,
  ics,
  d1 = 0.01,
  fd2 = 0.01,
  d3 = 0.01,
  customprior,
  minxi,
  maxxi,
  extramodels = FALSE,
  aderivs = TRUE
)
}
\arguments{
\item{x}{a vector of training data values}

\item{y}{a vector of values at which to calculate the density and distribution functions}

\item{ics}{initial conditions for the maximum likelihood search}

\item{d1}{the delta used in the numerical derivatives with respect to the parameter}

\item{fd2}{the fractional delta used in the numerical derivatives with respect to the parameter}

\item{d3}{the delta used in the numerical derivatives with respect to the parameter}

\item{customprior}{a custom value for the slope of the log prior at the maxlik estimate}

\item{minxi}{minimum value of shape parameter xi}

\item{maxxi}{maximum value of shape parameter xi}

\item{extramodels}{logical that indicates whether to add three additional prediction models}

\item{aderivs}{logical for whether to use analytic derivatives (instead of numerical)}
}
\value{
A vector of parameter estimates, two pdf vectors, two cdf vectors
}
\description{
Densities for 5 predictions
}
