% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{plot_pp}
\alias{plot_pp}
\title{P-P Plot}
\usage{
plot_pp(x, fits)
}
\arguments{
\item{x}{numeric vector of sample data}

\item{fits}{a list object produced from fit_univariate, fit_empirical, or
fit_univariate_man}
}
\value{
ggplot of percentile-percentile comparison of theoretical distribution
}
\description{
P-P Plot
}
\examples{
library(ggplot2)
set.seed(37)
x <- rgamma(10000, 5)
dists <- c('gamma', 'lnorm', 'weibull')
fits <- lapply(dists, fit_univariate, x = x)
plot_pp(x, fits) +
theme_bw()
}
