% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spotratecurve-class.R
\name{spotratecurve-helpers}
\alias{spotratecurve-helpers}
\alias{closest,SpotRateCurve,Term-method}
\alias{closest,SpotRateCurve,character-method}
\alias{first,SpotRateCurve,Term-method}
\alias{first,SpotRateCurve,character-method}
\alias{last,SpotRateCurve,Term-method}
\alias{last,SpotRateCurve,character-method}
\alias{first}
\alias{last}
\alias{closest}
\title{SpotRateCurve helpers}
\usage{
first(x, t)

last(x, t)

closest(x, t)
}
\arguments{
\item{x}{a SpotRateCurve object.}

\item{t}{a Term object.

\code{first} filters the first elements of the SpotRateCurve according to the
given term.

\code{last} filters the last elements of the SpotRateCurve according to the
given term.

\code{closest} selects the element of the SpotRateCurve that is the closest to
the given term.}
}
\value{
A \code{SpotRateCurve} object that is a subset of the given curve.
The elements returned are select according to the operation executed.
}
\description{
Helpers methods that return parts of a SpotRateCurve object according to a
given term.
}
\examples{
terms <- c(1, 11, 26, 27, 28)
rates <- c(0.0719, 0.056, 0.0674, 0.0687, 0.07)
curve <- spotratecurve(rates, terms, "discrete", "actual/365", "actual")
first(curve, "10 days")
last(curve, "10 days")
closest(curve, "10 days")
}
