% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/historical.R
\name{fixer_historical}
\alias{fixer_historical}
\title{Historic exchange rates}
\usage{
fixer_historical(date = NULL, base = "EUR", symbols = NULL)
}
\arguments{
\item{date}{A date in YYYY-MM-DD format, or any value that can be coerced
to YYYY-MM-DD format with \code{as.Date()}. Defaults to \code{NULL}, which
returns the latest conversion data.}

\item{base}{The base currency to index other currencies against.
Defaults to \code{"EUR"}. See \code{\link{fixer_symbols}} for details on
symbol options.}

\item{symbols}{A character vector of the symbols of currencies to return
exchange rates for, or a string for a single currency. Defaults to
\code{NULL} and returns all available currencies. See
\code{\link{fixer_symbols}} for details on symbol options.}
}
\value{
A tibble with exchange rates to the base currency on a given date.
}
\description{
Return currency exchange rates for a given date,
from 1999 to the present.

Historical exchange rates are available on all paid
'fixer.io' accounts.
}
\examples{
\dontrun{

historical <- fixer_historical(date = "2017-05-18")

}
}
