% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MiscFuns.R
\name{logLik.fixest}
\alias{logLik.fixest}
\title{Extracts the log-likelihood}
\usage{
\method{logLik}{fixest}(object, ...)
}
\arguments{
\item{object}{A \code{fixest} object. Obtained using the functions \code{\link[fixest]{femlm}}, \code{\link[fixest]{feols}} or \code{\link[fixest]{feglm}}.}

\item{...}{Not currently used.}
}
\value{
It returns a numeric scalar.
}
\description{
This function extracts the log-likelihood from a \code{fixest} estimation.
}
\details{
This function extracts the log-likelihood based on the model fit. You can have more information on the likelihoods in the details of the function \code{\link[fixest]{femlm}}.
}
\examples{

# simple estimation on iris data with "Species" fixed-effects
res = femlm(Sepal.Length ~ Sepal.Width + Petal.Length +
            Petal.Width | Species, iris)

nobs(res)
logLik(res)


}
\seealso{
See also the main estimation functions \code{\link[fixest]{femlm}}, \code{\link[fixest]{feols}} or \code{\link[fixest]{feglm}}. Other statistics functions: \code{\link[fixest]{AIC.fixest}}, \code{\link[fixest]{BIC.fixest}}.
}
\author{
Laurent Berge
}
