% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MiscFuns.R
\name{setFixest_se}
\alias{setFixest_se}
\alias{getFixest_se}
\title{Sets the default type of standard errors to be used}
\usage{
setFixest_se(no_FE = "standard", one_FE = "cluster", two_FE = "cluster")

getFixest_se()
}
\arguments{
\item{no_FE}{Character scalar equal to either: \code{"standard"} (default), or \code{"white"}. The type of standard-errors to use by default for estimations without fixed-effects.}

\item{one_FE}{Character scalar equal to either: \code{"standard"}, \code{"white"}, or \code{"cluster"} (default). The type of standard-errors to use by default for estimations with \emph{one} fixed-effect.}

\item{two_FE}{Character scalar equal to either: \code{"standard"}, \code{"white"}, \code{"cluster"}, or \code{"twoway"} (default). The type of standard-errors to use by default for estimations with \emph{two or more} fixed-effects.}
}
\value{
The function \code{getFixest_se()} returns a list with three elements containing the default for estimations i) wihtout, ii) with one, or iii) with two or more fixed-effects.
}
\description{
This functions defines or extracts the default type of standard-errors to computed in \code{fixest} \code{\link[fixest:summary.fixest]{summary}}, and \code{\link[fixest:vcov.fixest]{vcov}}.
}
\examples{

# By default:
# - no fixed-effect (FE): standard
# - one or more FEs: cluster

data(base_did)
est_no_FE  = feols(y ~ x1, base_did)
est_one_FE = feols(y ~ x1 | id, base_did)
est_two_FE = feols(y ~ x1 | id + period, base_did)

etable(est_no_FE, est_one_FE, est_two_FE)

# Changing the default standard-errors
setFixest_se(no_FE = "white", one_FE = "standard", two_FE = "twoway")
etable(est_no_FE, est_one_FE, est_two_FE)

# Reseting the defaults
setFixest_se()


}
