% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/response.R
\name{response}
\alias{response}
\alias{response.default}
\alias{response.flashlight}
\title{Response of flashlight}
\usage{
response(object, ...)

\method{response}{default}(object, ...)

\method{response}{flashlight}(object, ...)
}
\arguments{
\item{object}{An object of class \code{flashlight}.}

\item{...}{Arguments used to update the flashlight before extracting the response.}
}
\value{
A numeric vector of responses.
}
\description{
Extracts response from object of class \code{flashlight}.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default method not implemented yet.

\item \code{flashlight}: Extract response from flashlight object.
}}

\examples{
fit <- lm(Sepal.Length ~ ., data = iris)
(fl <- flashlight(model = fit, data = iris, y = "Sepal.Length", label = "ols"))
response(fl)[1:5]
response(fl, data = iris[1:5, ])
response(fl, data = iris[1:5, ], linkinv = exp)
}
