% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/light_effects.R
\name{light_effects}
\alias{light_effects}
\alias{light_effects.default}
\alias{light_effects.flashlight}
\alias{light_effects.multiflashlight}
\title{Combination of Response, Predicted, Partial Dependence, and ALE profiles.}
\usage{
light_effects(x, ...)

\method{light_effects}{default}(x, ...)

\method{light_effects}{flashlight}(
  x,
  v,
  data = NULL,
  by = x$by,
  stats = c("mean", "quartiles"),
  breaks = NULL,
  n_bins = 11,
  cut_type = c("equal", "quantile"),
  use_linkinv = TRUE,
  value_name = "value",
  q1_name = "q1",
  q3_name = "q3",
  label_name = "label",
  type_name = "type",
  counts_name = "counts",
  counts_weighted = FALSE,
  v_labels = TRUE,
  pred = NULL,
  pd_indices = NULL,
  pd_n_max = 1000,
  pd_seed = NULL,
  ale_two_sided = TRUE,
  ...
)

\method{light_effects}{multiflashlight}(
  x,
  v,
  data = NULL,
  breaks = NULL,
  n_bins = 11,
  cut_type = c("equal", "quantile"),
  ...
)
}
\arguments{
\item{x}{An object of class \code{flashlight} or \code{multiflashlight}.}

\item{...}{Further arguments passed to \code{cut3} resp. \code{formatC} in forming the cut breaks of the \code{v} variable.}

\item{v}{The variable to be profiled.}

\item{data}{An optional \code{data.frame}.}

\item{by}{An optional vector of column names used to additionally group the results.}

\item{stats}{Statistic to calculate for the response profile: "mean" or "quartiles".}

\item{breaks}{Cut breaks for a numeric \code{v}.}

\item{n_bins}{Maxmium number of unique values to evaluate for numeric \code{v}.}

\item{cut_type}{For the default "equal", bins of equal width are created for \code{v} by \code{pretty}. Choose "quantile" to create quantile bins (recommended if interested in ALE).}

\item{use_linkinv}{Should retransformation function be applied? Default is TRUE.}

\item{value_name}{Column name in resulting data objects containing the profile value. Defaults to "value".}

\item{q1_name}{Name of the resulting column with first quartile values. Only relevant for \code{stats} "quartiles".}

\item{q3_name}{Name of the resulting column with third quartile values. Only relevant for \code{stats} "quartiles".}

\item{label_name}{Column name in resulting \code{data} containing the label of the flashlight. Defaults to "label".}

\item{type_name}{Name of the column in \code{data} containing \code{type}.}

\item{counts_name}{Name of the column containing counts.}

\item{counts_weighted}{Should counts be weighted by the case weights? If TRUE, the sum of \code{w} is returned by group.}

\item{v_labels}{If FALSE, return group centers of \code{v} instead of labels. Only relevant if \code{v} is numeric with many distinct values. In that case useful if e.g. different flashlights use different data sets.}

\item{pred}{Optional vector with predictions (after application of inverse link). Can be used to avoid recalculation of predictions over and over if the functions is to be repeatedly called for different \code{v} and predictions are computationally expensive to make.}

\item{pd_indices}{A vector of row numbers to consider in calculating partial dependence and ALE profiles. Useful to force all flashlights to use the same basis for calculations of partial dependence and ALE.}

\item{pd_n_max}{Maximum number of ICE profiles to consider for partial depencence and ALE calculation (will be randomly picked from \code{data}).}

\item{pd_seed}{An integer random seed used to sample ICE profiles for partial dependence and ALE.}

\item{ale_two_sided}{If \code{TRUE}, \code{v} is continuous and \code{breaks} are passed or being calculated, then two-sided derivatives are calculated for ALE instead of left derivatives. This aligns the results better with the x labels. More specifically: Usually, local effects at value x are calculated using points between x-e and x. Set \code{ale_two_sided = TRUE} to use points between x-e/2 and x+e/2.}
}
\value{
An object of classes \code{light_effects}, \code{light} (and a list) with the following elements.
\itemize{
  \item \code{response} A tibble containing the response profiles.
  \item \code{predicted} A tibble containing the prediction profiles.
  \item \code{pd} A tibble containing the partial dependence profiles.
  \item \code{ale} A tibble containing the ALE profiles.
  \item \code{by} Same as input \code{by}.
  \item \code{v} The variable(s) evaluated.
  \item \code{stats} Same as input \code{stats}.
  \item \code{value_name} Same as input \code{value_name}.
  \item \code{q1_name} Same as input \code{q1_name}.
  \item \code{q3_name} Same as input \code{q3_name}.
  \item \code{label_name} Same as input \code{label_name}.
  \item \code{type_name} Same as input \code{type}.
  \item \code{counts_name} Same as input \code{counts_name}.
}
}
\description{
Calculates response- prediction-, partial dependence, and ALE profiles of a (multi-)flashlight with respect to a covariable \code{v}.
}
\details{
Note that ALE profiles are being calibrated by (weighted) average predictions. The resulting level might be quite different from the one of the partial dependence profiles.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default method.

\item \code{flashlight}: Profiles for a flashlight object.

\item \code{multiflashlight}: Effect profiles for a multiflashlight object.
}}

\examples{
fit_full <- lm(Sepal.Length ~ ., data = iris)
mod_full <- flashlight(model = fit_full, label = "full", data = iris, y = "Sepal.Length")
light_effects(mod_full, v = "Species")
light_effects(mod_full, v = "Species", stats = "quartiles")
}
\seealso{
\code{\link{light_profile}}, \code{\link{plot.light_effects}}.
}
