% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/light_scatter.R
\name{light_scatter}
\alias{light_scatter}
\alias{light_scatter.default}
\alias{light_scatter.flashlight}
\alias{light_scatter.multiflashlight}
\title{Scatter}
\usage{
light_scatter(x, ...)

\method{light_scatter}{default}(x, ...)

\method{light_scatter}{flashlight}(
  x,
  v,
  data = x$data,
  by = x$by,
  type = c("predicted", "response", "residual", "shap"),
  use_linkinv = TRUE,
  n_max = 400,
  seed = NULL,
  value_name = "value",
  label_name = "label",
  type_name = "type",
  ...
)

\method{light_scatter}{multiflashlight}(x, ...)
}
\arguments{
\item{x}{An object of class \code{flashlight} or \code{multiflashlight}.}

\item{...}{Further arguments passed from or to other methods.}

\item{v}{The variable to be shown on the x-axis.}

\item{data}{An optional \code{data.frame}. Not relevant for \code{type = "shap"}.}

\item{by}{An optional vector of column names used to additionally group the results.}

\item{type}{Type of the profile: Either "predicted", "response", "residual", or "shap".}

\item{use_linkinv}{Should retransformation function be applied? Default is TRUE. Not used for \code{type = "shap"}.}

\item{n_max}{Maximum number of data rows to select. Will be randomly picked from the relevant data.}

\item{seed}{An integer random seed used for subsampling.}

\item{value_name}{Column name in resulting \code{data} containing the values belonging to \code{type}. Defaults to "value".}

\item{label_name}{Column name in resulting \code{data} containing the label of the flashlight. Defaults to "label".}

\item{type_name}{Column name in the resulting \code{data} with the plot \code{type}.}
}
\value{
An object of class \code{light_scatter}, \code{light} (and a list) with the following elements.
\itemize{
\item \code{data} A tibble with results. Can be used to build fully customized visualizations.
\item \code{by} Same as input \code{by}.
\item \code{v} The variable evaluated.
\item \code{type} Same as input \code{type}. For information only.
\item \code{value_name} Same as input \code{value_name}.
\item \code{label_name} Same as input \code{label_name}.
\item \code{type_name} Same as input \code{type_name}.
}
}
\description{
This function prepares values for drawing a scatter plot of predicted values, responses, residuals, or SHAP values against a selected variable.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default method not implemented yet.

\item \code{flashlight}: Variable profile for a flashlight.

\item \code{multiflashlight}: light_scatter for a multiflashlight.
}}

\examples{
fit_a <- lm(Sepal.Length ~ . -Petal.Length, data = iris)
fit_b <- lm(Sepal.Length ~ ., data = iris)
fl_a <- flashlight(model = fit_a, label = "without Petal.Length")
fl_b <- flashlight(model = fit_b, label = "all")
fls <- multiflashlight(list(fl_a, fl_b), data = iris, y = "Sepal.Length")
pr <- light_scatter(fls, v = "Petal.Length")
plot(light_scatter(fls, "Petal.Length", by = "Species", type = "residual"), alpha = 0.2)
}
\seealso{
\code{\link{plot.light_scatter}}.
}
