% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{BH_procedure}
\alias{BH_procedure}
\title{Multiple statistical hypothesis testing with the Benjamini-Hochberg procedure}
\usage{
BH_procedure(pvalues, alpha = 0.01, ...)
}
\arguments{
\item{pvalues}{a vector of p-values, with length N}

\item{alpha}{a numeric between 0 and 1}

\item{...}{same arguments as in function base::sort, except "index.return"
which is set to TRUE.}
}
\value{
A named listed with entries:
\itemize{
\item H0: a logical vector of length N. The nth entry has value TRUE if the
null hypothesis associated with the nth p-value is not rejected and FALSE
otherwise.
\item pk: the decision threshold. A p-value under this threshold leads to
rejection of the associated null hypothesis.
\item alpha: the chosen significance level
\item pvalues: the vector of p-values provided to apply the
Benjamini-Hochberg procedure.
}
}
\description{
This function applies the procedure described in Benjamini & Hochberg (1995)
for controlling the False Discovery Rate in multiple statistical hypothesis
testing.
}
\details{
The procedure works as follows. Let N p-values \eqn{p_i}
(with \eqn{i=1,\ldots,N}) and a significance level \eqn{\alpha}. The decision
threshold is \eqn{p_k} where \eqn{k = max(i;p_{(i)} <= \alpha \frac{i}{N})}
where \eqn{p_{(i)}} are the sorted p-values \eqn{p_i}. For every test with
\eqn{p_i \le p_k}, the null hypothesis is rejected. By convention
\eqn{p_{(0)} = 0}.
}
\references{
Benjamini, Y., & Hochberg, Y. (1995). "Controlling the false discovery rate: a
practical and powerful approach to multiple testing." \emph{Journal of the
Royal statistical society: series B (Methodological)}, 57(1), 289-300.
doi:https://doi.org/10.1111/j.2517-6161.1995.tb02031.x
}
