% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flatxml.r
\name{fxml_hasSiblings}
\alias{fxml_hasSiblings}
\title{Siblings of an XML element}
\usage{
fxml_hasSiblings(xmlflat.df, elemid)
}
\arguments{
\item{xmlflat.df}{A flat XML dataframe created with \code{\link{fxml_importXMLFlat}}.}

\item{elemid}{The ID of the XML element. The ID is the value of the \code{elemid.} field in the flat XML dataframe.}
}
\value{
\code{TRUE}, if the the XML element with ID \code{elemid} has at least one sibling, \code{FALSE} otherwise.
}
\description{
Determines if an XML element has any siblings, i.e. elements on the same hierarchical level.
}
\examples{
# Load example file with population data from United Nations Statistics Division
# and create flat dataframe
example <- system.file("worldpopulation.xml", package="flatxml")
xml.dataframe <- fxml_importXMLFlat(example)

# Check if XML element with ID 4 (xml.dataframe$elemid. ==  4) has any siblings
# (elements on the same hierarchy level)
fxml_hasSiblings(xml.dataframe, 4)
}
\author{
Joachim Zuckarelli \email{joachim@zuckarelli.de}

#' @seealso \code{\link{fxml_numSiblings}}, \code{\link{fxml_getSiblings}}
}
