% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flatxml.r
\name{fxml_getChildren}
\alias{fxml_getChildren}
\title{Children of an XML element}
\usage{
fxml_getChildren(xmlflat.df, elemid)
}
\arguments{
\item{xmlflat.df}{A flat XML dataframe created with \code{\link{fxml_importXMLFlat}}.}

\item{elemid}{The ID of the XML element. The ID is the value of the \code{elemid.} field in the flat XML dataframe.}
}
\value{
The IDs (\code{xmlflat.df$elemid.}) of the children of the XML element with ID \code{elemid}. If no children exist, \code{NULL} is returned.
}
\description{
Returns the children of an XML element.
}
\examples{
# Load example file with population data from United Nations Statistics Division
# and create flat dataframe
example <- system.file("worldpopulation.xml", package="flatxml")
xml.dataframe <- fxml_importXMLFlat(example)

# Get all the children (sub-elements) of the XML element with ID 4 (xml.dataframe$elemid. ==  4)
fxml_hasChildren(xml.dataframe, 4)
}
\seealso{
\code{\link{fxml_hasChildren}}, \code{\link{fxml_numChildren}}
}
\author{
Joachim Zuckarelli \email{joachim@zuckarelli.de}
}
