% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{qgeneric}
\alias{qgeneric}
\title{Generic function to find quantiles of a distribution}
\usage{
qgeneric(pdist, p, matargs = NULL, ...)
}
\arguments{
\item{pdist}{Probability distribution function, for example,
\code{\link{pnorm}} for the normal distribution, which must be defined in
the current workspace.  This should accept and return vectorised parameters
and values.  It should also return the correct values for the entire real
line, for example a positive distribution should have \code{pdist(x)==0}
for \eqn{x<0}.}

\item{p}{Vector of probabilities to find the quantiles for.}

\item{matargs}{Character vector giving the elements of \code{...} which
represent vector parameters of the distribution.  Empty by default.  When
vectorised, these will become matrices.  This is used for the arguments
\code{gamma} and \code{knots} in \code{\link{qsurvspline}}.}

\item{...}{The remaining arguments define parameters of the distribution
\code{pdist}.  These MUST be named explicitly.

This may also contain the standard arguments \code{log.p} (logical; default
\code{FALSE}, if \code{TRUE}, probabilities p are given as log(p)), and
\code{lower.tail} (logical; if \code{TRUE} (default), probabilities are P[X
<= x] otherwise, P[X > x].).

If the distribution is bounded above or below, then this should contain
arguments \code{lbound} and \code{ubound} respectively, and these will be
returned if \code{p} is 0 or 1 respectively.  Defaults to \code{-Inf} and
\code{Inf} respectively.}
}
\value{
Vector of quantiles of the distribution at \code{p}.
}
\description{
Generic function to find the quantiles of a distribution, given the
equivalent probability distribution function.
}
\details{
This function is used by default for custom distributions for which a
quantile function is not provided.

It works by finding the root of the equation \eqn{h(q) = pdist(q) - p = 0}.
Starting from the interval \eqn{(-1, 1)}, the interval width is expanded by
50\% until \eqn{h()} is of opposite sign at either end.  The root is then
found using \code{\link{uniroot}}.

This assumes a suitably smooth, continuous distribution.

An identical function is provided in the \pkg{msm} package.
}
\examples{

qnorm(c(0.025, 0.975), 0, 1)
qgeneric(pnorm, c(0.025, 0.975), mean=0, sd=1) # must name the arguments
}
\author{
Christopher Jackson <chris.jackson@mrc-bsu.cam.ac.uk>
}
\keyword{distribution}
