% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mstate.R
\name{pars.fmsm}
\alias{pars.fmsm}
\title{Transition-specific parameters in a flexible parametric multi-state model}
\usage{
pars.fmsm(x, trans, newdata = NULL, tvar = "trans")
}
\arguments{
\item{x}{A multi-state model fitted with \code{\link{flexsurvreg}}.  See
\code{\link{msfit.flexsurvreg}} for the required form of the model and the
data.

\code{x} can also be a list of \code{\link{flexsurvreg}} models, with one
component for each permitted transition in the multi-state model, as
illustrated in \code{\link{msfit.flexsurvreg}}.}

\item{trans}{Matrix indicating allowed transitions.  See
\code{\link{msfit.flexsurvreg}}.}

\item{newdata}{A data frame specifying the values of covariates in the
fitted model, other than the transition number.  See
\code{\link{msfit.flexsurvreg}}.}

\item{tvar}{Variable in the data representing the transition type. Not
required if \code{x} is a list of models.}
}
\value{
A list with one component for each permitted transition. Each component
has one element for each parameter of the parametric distribution that generates
the corresponding event in the multi-state model.
}
\description{
List of maximum likelihood estimates of transition-specific parameters in
a flexible parametric multi-state model, at given covariate values.
}
\author{
Christopher Jackson \email{chris.jackson@mrc-bsu.cam.ac.uk}.
}
\keyword{models}
\keyword{survival}
