% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmixmsm.R
\name{qfinal_fmixmsm}
\alias{qfinal_fmixmsm}
\title{Quantiles of the distribution of the time until reaching a final state in a
mixture multi-state model}
\usage{
qfinal_fmixmsm(
  x,
  newdata = NULL,
  final = FALSE,
  B = NULL,
  n = 10000,
  probs = c(0.025, 0.5, 0.975)
)
}
\arguments{
\item{x}{Object returned by \code{\link{fmixmsm}}, representing a multi-state
model built from piecing together mixture models fitted by
\code{\link{flexsurvmix}}.}

\item{newdata}{Data frame or list of covariate values.   If omitted for a
model with covariates, a default is used, defined by all combinations of
factors if the only covariates in the model are factors, or all covariate
values of zero if there are any non-factor covariates in the model.}

\item{final}{If \code{TRUE} then the mean time to the final state is
calculated for each final state, by taking a weighted average of the mean
time to travel each pathway ending in that final state, weighted by the
probability of the pathway.   If \code{FALSE}  (the default) then a
separate mean is calculated for each pathway.}

\item{B}{Number of simulations to use to compute 95\% confidence intervals,
based on the asymptotic multivariate normal distribution of the basic
parameter estimates.  If \code{B=NULL} then intervals are not computed.}

\item{n}{Number of individual-level simulations to use to characterise the
time-to-event distributions}

\item{probs}{Quantiles to calculate, by default, \code{c(0.025, 0.5, 0.975)}}
}
\value{
Data frame of quantiles of the time to final state by pathway and
  covariate value, or by final state and covariate value.
}
\description{
Calculate the quantiles of the time from the start of the process to each
possible final (or "absorbing") state in a mixture multi-state model.
Models with cycles are not supported.
}
