% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flextable.R
\name{set_header_df}
\alias{set_header_df}
\title{Set flextable's header rows}
\usage{
set_header_df(x, mapping = NULL, key = "col_keys")
}
\arguments{
\item{x}{a \code{flextable} object}

\item{mapping}{a \code{data.frame} specyfing for each colname
content of the column.}

\item{key}{column to use as key when joigning data_mapping.}
}
\description{
Use a data.frame to specify flextable's header rows.

The data.frame must contain a column whose values match flextable
\code{col_keys} argument, this column will be used as join key. The
other columns will be displayed as header rows. The leftmost column
is used as the top header row and the rightmost column
is used as the bottom header row. Identical values will be merged (
vertically and horizontally).
}
\examples{
typology <- data.frame(
  col_keys = c( "Sepal.Length", "Sepal.Width", "Petal.Length",
                "Petal.Width", "Species" ),
  what = c("Sepal", "Sepal", "Petal", "Petal", "Species"),
  measure = c("Length", "Width", "Length", "Width", "Species"),
  stringsAsFactors = FALSE )

ft <- flextable( head( iris ))
ft <- set_header_df(ft, mapping = typology, key = "col_keys" )
ft <- theme_vanilla(ft)
ft <- autofit(ft)
}
