% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatters.R
\name{colformat_lgl}
\alias{colformat_lgl}
\alias{colformat_lgl.flextable}
\title{format logical columns}
\usage{
colformat_lgl(x, ...)

\method{colformat_lgl}{flextable}(x, col_keys, true = "true",
  false = "false", na_str = "", prefix = "", suffix = "", ...)
}
\arguments{
\item{x}{a flextable object}

\item{...}{additional arguments, unused}

\item{col_keys}{names of the colkeys}

\item{false, true}{string to be used for logical columns}

\item{na_str}{string to be used for NA values}

\item{prefix}{string to be used as prefix or suffix}

\item{suffix}{string to be used as prefix or suffix}
}
\description{
Format logical columns in a flextable.
}
\examples{
dat <- data.frame(a = c(TRUE, FALSE), b = c(FALSE, TRUE))

ft <- flextable(dat)
ft <- colformat_lgl(x = ft, col_keys = c("a", "b"))
autofit(ft)
}
\seealso{
Other columns formatters: \code{\link{colformat_char}},
  \code{\link{colformat_int}}, \code{\link{colformat_num}}
}
\concept{columns formatters}
