% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/display.R
\name{display}
\alias{display}
\title{Define flextable displayed values}
\usage{
display(x, i = NULL, col_key, pattern, formatters = list(),
  fprops = list(), part = "body")
}
\arguments{
\item{x}{a flextable object}

\item{i}{rows selection}

\item{col_key}{column to modify, a single character}

\item{pattern}{string to format}

\item{formatters}{a list of formula, left side for the name,
right side for the content.}

\item{fprops}{a named list of \link[officer]{fp_text}}

\item{part}{partname of the table (one of 'all', 'body', 'header', 'footer')}
}
\description{
Modify flextable displayed values by specifying a
string expression. Function is handling complex formatting as well as
image insertion.
}
\section{pattern}{

It defined the template used to format the produced strings. Names enclosed
by double braces will be evaluated as R code, the corresponding R code is defined
with the argument \code{formatters}.
}

\section{formatters}{

Each compound is specifying the R code to execute to produce strings that will be
substituted in the \code{pattern} argument. An element must be a formula: the
left-hand side is a name (matching a name enclosed by double braces in
\code{pattern}) and the right-hand side is an R expression to be evaluated (that
will produce the corresponding strings).

The function is designed to work with columns in the dataset provided to
\code{flextable} (the col_keys).
}

\section{fprops}{

A named list of \link[officer]{fp_text}. It defines the formatting properties
associated to a compound in \code{formatters}. If not defined for an element
of \code{formatters}, the default formatting properties will be applied.
}

\examples{
library(officer)
# Formatting data values example ------
ft <- flextable(head( mtcars, n = 10))
ft <- display(ft, col_key = "carb",
  i = ~ drat > 3.5, pattern = "# {{carb}}",
  formatters = list(carb ~ sprintf("\%.1f", carb)),
  fprops = list(carb = fp_text(color="orange") ) )
\donttest{ft <- autofit(ft)}
}
