% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_flextable.R
\name{merge_v}
\alias{merge_v}
\title{Merge flextable cells vertically}
\usage{
merge_v(x, j = NULL, target = NULL, part = "body")
}
\arguments{
\item{x}{\code{flextable} object}

\item{j}{column to used to find consecutive values to be merged. Columns
from orignal dataset can also be used.}

\item{target}{columns names where cells have to be merged.}

\item{part}{partname of the table where merge has to be done.}
}
\description{
Merge flextable cells vertically when consecutive cells have
identical values. Text of formatted values are used to compare
values if available.
}
\section{Illustrations}{


\if{html}{\figure{fig_merge_v_1.png}{options: width=100\%}}

\if{html}{\figure{fig_merge_v_2.png}{options: width=100\%}}
}

\examples{
ft_merge <- flextable(mtcars)
ft_merge <- merge_v(ft_merge, j = c("gear", "carb"))
ft_merge

data_ex <- structure(list(srdr_id = c(
  "175124", "175124", "172525", "172525",
  "172545", "172545", "172609", "172609", "172609"
), substances = c(
  "alcohol",
  "alcohol", "alcohol", "alcohol", "cannabis",
  "cannabis", "alcohol\n cannabis\n other drugs",
  "alcohol\n cannabis\n other drugs",
  "alcohol\n cannabis\n other drugs"
), full_name = c(
  "TAU", "MI", "TAU", "MI (parent)", "TAU", "MI",
  "TAU", "MI", "MI"
), article_arm_name = c(
  "Control", "WISEteens",
  "Treatment as usual", "Brief MI (b-MI)", "Assessed control",
  "Intervention", "Control", "Computer BI", "Therapist BI"
)), row.names = c(
  NA,
  -9L
), class = c("tbl_df", "tbl", "data.frame"))


ft_1 <- flextable(data_ex)
ft_1 <- theme_box(ft_1)
ft_2 <- merge_v(ft_1, j = "srdr_id",
  target = c("srdr_id", "substances"))
  ft_2
}
\seealso{
Other flextable merging function: 
\code{\link{merge_at}()},
\code{\link{merge_h_range}()},
\code{\link{merge_h}()},
\code{\link{merge_none}()}
}
\concept{flextable merging function}
