% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05_content.R
\name{as_bracket}
\alias{as_bracket}
\title{chunk with values in brackets}
\usage{
as_bracket(..., sep = ", ", p = "(", s = ")")
}
\arguments{
\item{...}{text and column names}

\item{sep}{separator}

\item{p}{prefix, default to '('}

\item{s}{suffix, default to ')'}
}
\description{
The function is producing a chunk by
pasting values and add the result in brackets.
It should be used inside a call to \code{\link{as_paragraph}}.
}
\examples{
ft <- flextable( head(iris),
  col_keys = c("Species", "Sepal", "Petal") )
ft <- set_header_labels(ft, Sepal="Sepal", Petal="Petal")
ft <- compose(ft, j = "Sepal",
  value = as_paragraph( as_bracket(Sepal.Length, Sepal.Width) ) )
ft <- compose(ft, j = "Petal",
  value = as_paragraph( as_bracket(Petal.Length, Petal.Width) ) )
autofit(ft)
}
\seealso{
Other chunk elements for paragraph: \code{\link{as_b}},
  \code{\link{as_chunk}}, \code{\link{as_image}},
  \code{\link{as_i}}, \code{\link{as_sub}},
  \code{\link{as_sup}}, \code{\link{hyperlink_text}},
  \code{\link{linerange}}, \code{\link{minibar}}
}
\concept{chunk elements for paragraph}
