% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chunk_images.R
\name{gg_chunk}
\alias{gg_chunk}
\title{gg plots chunk wrapper}
\usage{
gg_chunk(value, width = 1, height = 0.2)
}
\arguments{
\item{value}{gg objects, stored in a list column.}

\item{width, height}{size of the resulting png file in inches}
}
\description{
This function is used to insert mini gg plots into
flextable with function \code{\link[=compose]{compose()}}.
It should be used inside a call to \code{\link[=as_paragraph]{as_paragraph()}}.
}
\note{
This chunk option requires package officedown in a R Markdown
context with Word output format.

PowerPoint cannot mix images and text in a paragraph, images
are removed when outputing to PowerPoint format.
}
\section{Illustrations}{


\if{html}{\figure{fig_gg_chunk_1.png}{options: width=70\%}}
}

\examples{
library(data.table)
library(flextable)
if(require("ggplot2")){
  my_cor_plot <- function(x){
    cols <- colnames(x)[sapply(x, is.numeric)]
    x <- x[, .SD, .SDcols = cols]
    cormat <- as.data.table(cor(x))
    cormat$var1 <- colnames(cormat)
    cormat <- melt(cormat, id.vars = "var1", measure.vars = cormat$var1,
                   variable.name = "var2", value.name = "correlation")
    ggplot(data = cormat, aes(x=var1, y=var2, fill=correlation)) +
      geom_tile() + coord_equal() +
      scale_fill_gradient2(low = "blue",
                           mid = "white", high = "red", limits = c(-1, 1),
                           guide = FALSE) + theme_void()
  }
  z <- as.data.table(iris)
  z <- z[ , list(gg = list(my_cor_plot(.SD))), by = "Species"]
  ft <- flextable(z)
  ft <- mk_par(ft, j = "gg",
               value = as_paragraph(
                 gg_chunk(value = gg, width = 1, height = 1)
               ))
  ft
}
}
\seealso{
Other chunk elements for paragraph: 
\code{\link{as_bracket}()},
\code{\link{as_b}()},
\code{\link{as_chunk}()},
\code{\link{as_image}()},
\code{\link{as_i}()},
\code{\link{as_sub}()},
\code{\link{as_sup}()},
\code{\link{hyperlink_text}()},
\code{\link{linerange}()},
\code{\link{lollipop}()},
\code{\link{minibar}()},
\code{\link{plot_chunk}()}
}
\concept{chunk elements for paragraph}
