% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/defaults.R
\name{fp_text_default}
\alias{fp_text_default}
\title{Text formatting properties}
\usage{
fp_text_default(
  color = flextable_global$defaults$font.color,
  font.size = flextable_global$defaults$font.size,
  bold = FALSE,
  italic = FALSE,
  underlined = FALSE,
  font.family = flextable_global$defaults$font.family,
  cs.family = NULL,
  eastasia.family = NULL,
  hansi.family = NULL,
  vertical.align = "baseline",
  shading.color = "transparent"
)
}
\arguments{
\item{color}{font color - a single character value specifying
a valid color (e.g. "#000000" or "black").}

\item{font.size}{font size (in point) - 0 or positive integer value.}

\item{bold}{is bold}

\item{italic}{is italic}

\item{underlined}{is underlined}

\item{font.family}{single character value. Specifies the font to
be used to format characters in the Unicode range (U+0000-U+007F).}

\item{cs.family}{optional font to be used to format
characters in a complex script Unicode range. For example, Arabic
text might be displayed using the "Arial Unicode MS" font.}

\item{eastasia.family}{optional font to be used to
format characters in an East Asian Unicode range. For example,
Japanese text might be displayed using the "MS Mincho" font.}

\item{hansi.family}{optional. Specifies the font to be used to format
characters in a Unicode range which does not fall into one of the
other categories.}

\item{vertical.align}{single character value specifying font vertical alignments.
Expected value is one of the following : default \code{'baseline'}
or \code{'subscript'} or \code{'superscript'}}

\item{shading.color}{shading color - a single character value specifying
a valid color (e.g. "#000000" or "black").}
}
\description{
Create a \code{\link[=fp_text]{fp_text()}} object that uses
defaut values defined in flextable defaults formatting properties, i.e.
default font color, font size and font family (see \code{\link[=set_flextable_defaults]{set_flextable_defaults()}}).
(see \code{\link[=set_flextable_defaults]{set_flextable_defaults()}}).
}
\examples{
fp_text_default(bold = TRUE)
}
\seealso{
\code{\link[=as_chunk]{as_chunk()}}

Other functions for defining formatting properties: 
\code{\link{fp_border_default}()}
}
\concept{functions for defining formatting properties}
