% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatters.R
\name{colformat_image}
\alias{colformat_image}
\title{format cells as images}
\usage{
colformat_image(
  x,
  i = NULL,
  j = NULL,
  width,
  height,
  na_str = get_flextable_defaults()$na_str,
  nan_str = get_flextable_defaults()$nan_str,
  prefix = "",
  suffix = ""
)
}
\arguments{
\item{x}{a flextable object}

\item{i}{rows selection}

\item{j}{columns selection.}

\item{width, height}{size of the png file in inches}

\item{na_str, nan_str}{string to be used for NA and NaN values}

\item{prefix, suffix}{string to be used as prefix or suffix}
}
\description{
Format image paths as images in a flextable.
}
\section{Illustrations}{


\if{html}{\figure{fig_colformat_image_1.png}{options: width="400"}}
}

\examples{
img.file <- file.path( R.home("doc"), "html", "logo.jpg" )

dat <- head(iris)
dat$Species <- as.character(dat$Species)
dat[c(1, 3, 5), "Species"] <- img.file

myft <- flextable( dat)
myft <- colformat_image(
  myft, i = c(1, 3, 5),
  j = "Species", width = .20, height = .15)
ft <- autofit(myft)
ft
}
\seealso{
Other cells formatters: 
\code{\link{colformat_char}()},
\code{\link{colformat_datetime}()},
\code{\link{colformat_date}()},
\code{\link{colformat_double}()},
\code{\link{colformat_int}()},
\code{\link{colformat_lgl}()},
\code{\link{colformat_num}()},
\code{\link{set_formatter}()}
}
\concept{cells formatters}
