% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/printers.R
\name{knit_print.flextable}
\alias{knit_print.flextable}
\title{Render flextable in rmarkdown}
\usage{
\method{knit_print}{flextable}(x, ...)
}
\arguments{
\item{x}{a \code{flextable} object}

\item{...}{arguments passed to \code{\link[=flextable_to_rmd]{flextable_to_rmd()}}.}
}
\description{
Function used to render flextable in knitr/rmarkdown documents.

You should not call this method directly. This function is used by the knitr
package to automatically display a flextable in an "R Markdown" document from
a chunk. However, it is recommended to read its documentation in order to get
familiar with the different options available.

R Markdown outputs can be :
\itemize{
\item HTML
\item 'Microsoft Word'
\item 'Microsoft PowerPoint'
\item PDF
}

\if{html}{\figure{fig_formats.png}{options: width="200"}}

Table captioning is a flextable feature compatible with R Markdown
documents. The feature is available for HTML, PDF and Word documents.
Compatibility with the "bookdown" package is also ensured, including the
ability to produce captions so that they can be used in cross-referencing.

For Word, it's recommanded to work with package 'officedown' that supports
all features of flextable.
}
\note{
Supported formats require some
minimum \href{https://pandoc.org/installing.html}{pandoc} versions:

\tabular{rc}{
\strong{Output format} \tab \strong{pandoc minimal version} \cr
HTML              \tab >= 1.12\cr
Word (docx)       \tab >= 2.0 \cr
PowerPoint (pptx) \tab >= 2.4 \cr
PDF               \tab >= 1.12
}
}
\section{Chunk options}{


Some features, often specific to an output format, are available to help you
configure some global settings relatve to the table output. knitr's chunk options
are to be used to change the default settings:

\tabular{lcccccc}{
\strong{chunk option} \tab \strong{property} \tab \strong{default value} \tab \strong{HTML} \tab \strong{docx} \tab \strong{PDF} \tab \strong{pptx} \cr
ft.align        \tab flextable alignment, supported values are 'left', 'center' and 'right'    \tab 'center' \tab yes \tab yes \tab yes \tab no \cr
ft.shadow       \tab HTML option, disable shadow dom (set to \code{FALSE}) for pagedown. \tab TRUE    \tab yes  \tab no \tab no  \tab no \cr
ft.htmlscroll   \tab HTML option, add a scroll if table is too big to fit into its HTML container. \tab TRUE    \tab yes  \tab no \tab no  \tab no \cr
ft.split        \tab Word option 'Allow row to break across pages' can be activated when TRUE. \tab FALSE    \tab no  \tab yes \tab no  \tab no \cr
ft.keepnext     \tab Word option 'keep rows together' can be desactivated when FALSE \tab TRUE    \tab no  \tab yes \tab no  \tab no \cr
ft.tabcolsep    \tab space between the text and the left/right border of its containing cell   \tab 0      \tab no  \tab no  \tab yes \tab no \cr
ft.arraystretch \tab height of each row relative to its default height                         \tab 1.5      \tab no  \tab no  \tab yes \tab no \cr
ft.latex.float  \tab type of floating placement in the document, one of 'none', 'float', 'wrap-r', 'wrap-l', 'wrap-i', 'wrap-o' \tab 'none'      \tab no  \tab no  \tab yes \tab no \cr
ft.left         \tab left coordinates in inches                                                \tab 1.0      \tab no  \tab no  \tab no  \tab yes\cr
ft.top          \tab top coordinates in inches                                                 \tab 2.0      \tab no  \tab no  \tab no  \tab yes
}

If some values are to be used all the time in the same
document, it is recommended to set these values in a
'knitr r chunk' by using function
\code{knitr::opts_chunk$set(ft.split=FALSE, ft.keepnext = FALSE, ...)}.

See \code{\link[=flextable_to_rmd]{flextable_to_rmd()}} for more details about these options.
}

\section{Table caption}{


Captions can be defined in two ways.

The first is with the \code{set_caption} function. If it is used,
the other method will be ignored. The second method is by using
knitr chunk option \code{tab.cap}.

\if{html}{\out{<div class="sourceCode">}}\preformatted{set_caption(x, caption = "my caption")
}\if{html}{\out{</div>}}

If \code{set_caption} function is not used, caption identifier will be
read from knitr's chunk option \code{tab.id}. Note that in a bookdown and
when not using \code{officedown::rdocx_document()}, the usual numbering
feature of bookdown is used.

\code{tab.id='my_id'}.

Some options are available to customise captions for any output:\tabular{lcc}{
   \strong{label} \tab \strong{name} \tab \strong{value} \cr
   Word stylename to use for table captions. \tab tab.cap.style \tab NULL \cr
   caption id/bookmark \tab tab.id \tab NULL \cr
   caption \tab tab.cap \tab NULL \cr
   display table caption on top of the table or not \tab tab.topcaption \tab TRUE \cr
   caption table sequence identifier. \tab tab.lp \tab "tab:" \cr
}


Word output when \code{officedown::rdocx_document()} is used is coming with
more options such as ability to choose the prefix for numbering chunk for
example. The table below expose these options:\tabular{lcc}{
   \strong{label} \tab \strong{name} \tab \strong{value} \cr
   prefix for numbering chunk (default to   "Table "). \tab tab.cap.pre \tab Table \cr
   suffix for numbering chunk (default to   ": "). \tab tab.cap.sep \tab " :" \cr
   title number depth \tab tab.cap.tnd \tab 0 \cr
   caption prefix formatting properties \tab tab.cap.fp_text \tab fp_text_lite(bold = TRUE) \cr
   separator to use between title number and table number. \tab tab.cap.tns \tab "-" \cr
}
}

\section{HTML output}{


HTML output is using shadow dom to encapsule the table
into an isolated part of the page so that no clash happens
with styles. Some output may not support this feature. To our
knowledge, only the pagedown output is concerned.
Use knitr chunk option \code{ft.shadow=FALSE} to disable shadow dom.

If \code{ft.shadow=TRUE} some global CSS rules may change the
desired output of flextables.
}

\section{PDF output}{


Some features are not implemented in PDF due to technical
infeasibility. These are the padding, line_spacing and
height properties.

It is recommended to set theses values in a
'knitr r chunk' so that they are permanent
all along the document:
\code{knitr::opts_chunk$set(ft.tabcolsep=0, ft.latex.float = "none")}.

Background color and merged cells does not work well together
with PDF format. Authors are hoping to fix this issue in
the future.

See \code{\link[=add_latex_dep]{add_latex_dep()}} if caching flextable results in 'R Markdown'
documents.
}

\section{PowerPoint output}{


Auto-adjust Layout is not available for PowerPoint, PowerPoint only support
fixed layout. It's then often necessary to call function \code{\link[=autofit]{autofit()}} so
that the columns' widths are adjusted if user does not provide the withs.

Images cannot be integrated into tables with the PowerPoint format.
}

\examples{

# simple examples -----
demo_docx <- system.file(package = "flextable", "examples/rmd", "demo.Rmd")
rmd_file <- tempfile(fileext = ".Rmd")
file.copy(demo_docx, to = rmd_file, overwrite = TRUE)
rmd_file # R Markdown document used for demo
if (require("rmarkdown", quietly = TRUE)) {
  #  knitr::opts_chunk$set(webshot = "webshot2")
  #  render(input = rmd_file, output_format = "word_document", output_file = "doc.docx")
  #  render(input = rmd_file, output_format = "pdf_document", output_file = "doc.pdf")
  #  render(input = rmd_file, output_format = "html_document", output_file = "doc.html")
  #  render(input = rmd_file, output_format = "powerpoint_presentation", output_file = "pres.pptx")
  #  render(input = rmd_file, output_format = "slidy_presentation", output_file = "slidy.html")
  #  render(input = rmd_file, output_format = "beamer_presentation", output_file = "beamer.pdf")
  #  render(input = rmd_file, output_format = "pagedown::html_paged", output_file = "paged.html")
}


## bookdown examples wth captions and cross ref -----
# captions_example <- system.file(
#   package = "flextable",
#   "examples/rmd", "captions_example.Rmd")
#
# dir_tmp <- tempfile(pattern = "dir")
# dir.create(dir_tmp, showWarnings = FALSE, recursive = TRUE)
# file.copy(captions_example, dir_tmp)
# rmd_file <- file.path(dir_tmp, basename(captions_example))
#
# file.copy(captions_example, to = rmd_file, overwrite = TRUE)
#
# if(require("rmarkdown", quietly = TRUE)){
#   render(input = rmd_file,
#          output_format = word_document(),
#          output_file = "doc.docx")
#   render(input = rmd_file,
#          output_format = pdf_document(latex_engine = "xelatex"),
#          output_file = "doc.pdf")
#   render(input = rmd_file,
#          output_format = html_document(),
#          output_file = "doc.html")
#
#   # bookdown ----
#   if(require("bookdown", quietly = TRUE)){
#     render(input = rmd_file, output_format = word_document2(),
#            output_file = "book.docx")
#     render(input = rmd_file,
#            output_format = pdf_document2(latex_engine = "xelatex"),
#            output_file = "book.pdf")
#     render(input = rmd_file,
#            output_format = html_document2(),
#            output_file = "book.html")
#
#     # officedown ----
#     if(require("officedown", quietly = TRUE)){
#       render(input = rmd_file,
#              output_format = markdown_document2(base_format=rdocx_document),
#              output_file = "officedown.docx")
#     }
#   }
# }
# browseURL(dirname(rmd_file))

}
\seealso{
Other flextable print function: 
\code{\link{as_raster}()},
\code{\link{df_printer}()},
\code{\link{flextable_to_rmd}()},
\code{\link{gen_grob}()},
\code{\link{htmltools_value}()},
\code{\link{plot.flextable}()},
\code{\link{print.flextable}()},
\code{\link{save_as_docx}()},
\code{\link{save_as_html}()},
\code{\link{save_as_image}()},
\code{\link{save_as_pptx}()}
}
\concept{flextable print function}
