% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05_content.R
\name{as_bracket}
\alias{as_bracket}
\title{Chunk with values in brackets}
\usage{
as_bracket(..., sep = ", ", p = "(", s = ")")
}
\arguments{
\item{...}{text and column names}

\item{sep}{separator}

\item{p}{prefix, default to '('}

\item{s}{suffix, default to ')'}
}
\description{
The function is producing a chunk by
pasting values and add the result in brackets.

It is used to add it to the content of a cell of the
flextable with the functions \code{\link[=compose]{compose()}}, \code{\link[=append_chunks]{append_chunks()}}
or \code{\link[=prepend_chunks]{prepend_chunks()}}.
}
\examples{
ft <- flextable( head(iris),
  col_keys = c("Species", "Sepal", "Petal") )
ft <- set_header_labels(ft, Sepal="Sepal", Petal="Petal")
ft <- compose(ft, j = "Sepal",
  value = as_paragraph( as_bracket(Sepal.Length, Sepal.Width) ) )
ft <- compose(ft, j = "Petal",
  value = as_paragraph( as_bracket(Petal.Length, Petal.Width) ) )
ft
}
\seealso{
Other chunk elements for paragraph: 
\code{\link{as_b}()},
\code{\link{as_chunk}()},
\code{\link{as_equation}()},
\code{\link{as_highlight}()},
\code{\link{as_image}()},
\code{\link{as_i}()},
\code{\link{as_sub}()},
\code{\link{as_sup}()},
\code{\link{as_word_field}()},
\code{\link{colorize}()},
\code{\link{gg_chunk}()},
\code{\link{grid_chunk}()},
\code{\link{hyperlink_text}()},
\code{\link{linerange}()},
\code{\link{lollipop}()},
\code{\link{minibar}()},
\code{\link{plot_chunk}()}
}
\concept{chunk elements for paragraph}
