% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/printers.R
\name{save_as_html}
\alias{save_as_html}
\title{Save flextable objects in an 'HTML' file}
\usage{
save_as_html(..., values = NULL, path, lang = "en", title = "&#32;")
}
\arguments{
\item{...}{flextable objects, objects, possibly named. If named objects, names are
used as titles.}

\item{values}{a list (possibly named), each element is a flextable object. If named objects, names are
used as titles. If provided, argument \code{...} will be ignored.}

\item{path}{HTML file to be created}

\item{lang}{language of the document using IETF language tags}

\item{title}{page title}
}
\value{
a string containing the full name of the generated file
}
\description{
save a flextable in an 'HTML' file. This function
is useful to save the flextable in 'HTML' file without using
R Markdown (it is highly recommanded to use R Markdown
instead).
}
\examples{
ft1 <- flextable(head(iris))
tf1 <- tempfile(fileext = ".html")
save_as_html(ft1, path = tf1)
# browseURL(tf1)

ft2 <- flextable(head(mtcars))
tf2 <- tempfile(fileext = ".html")
save_as_html(
  `iris table` = ft1,
  `mtcars table` = ft2,
  path = tf2,
  title = "rhoooo"
)
# browseURL(tf2)
}
\seealso{
Other flextable print function: 
\code{\link{as_raster}()},
\code{\link{df_printer}()},
\code{\link{flextable_to_rmd}()},
\code{\link{gen_grob}()},
\code{\link{htmltools_value}()},
\code{\link{knit_print.flextable}()},
\code{\link{plot.flextable}()},
\code{\link{print.flextable}()},
\code{\link{save_as_docx}()},
\code{\link{save_as_image}()},
\code{\link{save_as_pptx}()},
\code{\link{save_as_rtf}()},
\code{\link{to_html.flextable}()}
}
\concept{flextable print function}
