% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/defaults.R
\name{fp_text_default}
\alias{fp_text_default}
\title{Text formatting properties}
\usage{
fp_text_default(
  color = flextable_global$defaults$font.color,
  font.size = flextable_global$defaults$font.size,
  bold = FALSE,
  italic = FALSE,
  underlined = FALSE,
  font.family = flextable_global$defaults$font.family,
  cs.family = NULL,
  eastasia.family = NULL,
  hansi.family = NULL,
  vertical.align = "baseline",
  shading.color = "transparent"
)
}
\arguments{
\item{color}{font color - a single character value specifying
a valid color (e.g. "#000000" or "black").}

\item{font.size}{font size (in point) - 0 or positive integer value.}

\item{bold}{is bold}

\item{italic}{is italic}

\item{underlined}{is underlined}

\item{font.family}{single character value. Specifies the font to
be used to format characters in the Unicode range (U+0000-U+007F).}

\item{cs.family}{optional font to be used to format
characters in a complex script Unicode range. For example, Arabic
text might be displayed using the "Arial Unicode MS" font.}

\item{eastasia.family}{optional font to be used to
format characters in an East Asian Unicode range. For example,
Japanese text might be displayed using the "MS Mincho" font.}

\item{hansi.family}{optional. Specifies the font to be used to format
characters in a Unicode range which does not fall into one of the
other categories.}

\item{vertical.align}{single character value specifying font vertical alignments.
Expected value is one of the following : default \code{'baseline'}
or \code{'subscript'} or \code{'superscript'}}

\item{shading.color}{shading color - a single character value specifying
a valid color (e.g. "#000000" or "black").}
}
\description{
Create a \code{\link[=fp_text]{fp_text()}} object that uses
defaut values defined in the flextable it applies to.

\code{fp_text_default()} is a handy function that will allow
you to specify certain formatting values to be applied
to a piece of text, the formatting values that are not
specified will simply be the existing formatting values.

For example, if you set the text in the cell to red
previously, using the code \code{fp_text_default(bold = TRUE)},
the formatting will be 'bold' but it will also be 'red'.

On the other hand, the \code{fp_text()} function forces you
to specify all the parameters, so we strongly recommend
working with \code{fp_text_default()} which was created
to replace the use of the former.

See also \code{\link[=set_flextable_defaults]{set_flextable_defaults()}} to modify flextable
defaults formatting properties.
}
\examples{
library(flextable)

set_flextable_defaults(
  font.size = 11, font.color = "#303030",
  padding = 3, table.layout = "autofit")
z <- flextable(head(cars))

z <- compose(
  x = z,
  i = ~ speed < 6,
  j = "speed",
  value = as_paragraph(
    as_chunk("slow... ", props = fp_text_default(color = "red")),
    as_chunk(speed, props = fp_text_default(italic = TRUE))
  )
)
z

init_flextable_defaults()

}
\seealso{
\code{\link[=as_chunk]{as_chunk()}}, \code{\link[=compose]{compose()}}, \code{\link[=append_chunks]{append_chunks()}}, \code{\link[=prepend_chunks]{prepend_chunks()}}

Other functions for defining formatting properties: 
\code{\link{fp_border_default}()}
}
\concept{functions for defining formatting properties}
