% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarizor.R
\name{fmt_2stats}
\alias{fmt_2stats}
\alias{fmt_summarizor}
\title{Format content for data generated with summarizor()}
\usage{
fmt_2stats(
  stat,
  num1,
  num2,
  cts,
  pcts,
  num1_mask = "\%.01f",
  num2_mask = "(\%.01f)",
  cts_mask = "\%.0f",
  pcts_mask = "(\%.02f\%\%)"
)

fmt_summarizor(
  stat,
  num1,
  num2,
  cts,
  pcts,
  num1_mask = "\%.01f",
  num2_mask = "(\%.01f)",
  cts_mask = "\%.0f",
  pcts_mask = "(\%.02f\%\%)"
)
}
\arguments{
\item{stat}{a character column containing the name of statictics}

\item{num1}{a numeric statistic to display such as a mean or a median}

\item{num2}{a numeric statistic to display such as a standard
deviation or a median absolute deviation.}

\item{cts}{a count to display}

\item{pcts}{a percentage to display}

\item{num1_mask}{format associated with \code{num1}, a format string
used by \code{\link[=sprintf]{sprintf()}}.}

\item{num2_mask}{format associated with \code{num2}, a format string
used by \code{\link[=sprintf]{sprintf()}}.}

\item{cts_mask}{format associated with \code{cts}, a format string
used by \code{\link[=sprintf]{sprintf()}}.}

\item{pcts_mask}{format associated with \code{pcts}, a format string
used by \code{\link[=sprintf]{sprintf()}}.}
}
\description{
This function was written to allow easy demonstrations
of flextable's ability to produce table summaries (with \code{\link[=summarizor]{summarizor()}}).
It assumes that we have either a quantitative variable, in which
case we will display the mean and the standard deviation, or a
qualitative variable, in which case we will display the count and the
percentage corresponding to each modality.
}
\examples{
library(flextable)
z <- summarizor(iris, by = "Species")

tab_1 <- tabulator(
  x = z,
  rows = c("variable", "stat"),
  columns = "Species",
  blah = as_paragraph(
    as_chunk(
      fmt_summarizor(
        stat = stat,
        num1 = value1, num2 = value2,
        cts = cts, pcts = percent
      )
    )
  )
)

ft_1 <- as_flextable(x = tab_1, separate_with = "variable")
ft_1 <- labelizor(
  x = ft_1, j = "stat",
  labels = c(
    mean_sd = "Moyenne (ecart-type)",
    median_iqr = "Mediane (IQR)",
    range = "Etendue",
    missing = "Valeurs manquantes"
  )
)
ft_1 <- autofit(ft_1)
ft_1
}
\seealso{
\code{\link[=summarizor]{summarizor()}}, \code{\link[=tabulator]{tabulator()}}, \code{\link[=mk_par]{mk_par()}}

Other text formatter functions: 
\code{\link{fmt_avg_dev}()},
\code{\link{fmt_dbl}()},
\code{\link{fmt_header_n}()},
\code{\link{fmt_int}()},
\code{\link{fmt_n_percent}()},
\code{\link{fmt_pct}()}
}
\concept{text formatter functions}
