% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary.R
\name{cacheBlockPermute1}
\alias{cacheBlockPermute1}
\title{Resampling Many V Statistics (Version 1)}
\usage{
cacheBlockPermute1(X, block_labels, nruns, p = 2)
}
\arguments{
\item{X}{The binary or real matrix on which to perform
permutation resampling}

\item{block_labels}{Length \eqn{P} vector recording the block label of each feature}

\item{nruns}{The resampling number (use at least 1000)}

\item{p}{The power \eqn{p} of \eqn{l_p^p}, i.e., \eqn{||x||_p^p = (x_1^p+...x_n^p)}}
}
\value{
A vector of resampled values of the \eqn{V} statistic
}
\description{
Generates a block permutation distribution of \eqn{V} statistic.
Precomputes distances and some indexing arrays to quickly
generate samples from the block permutation distribution of the \eqn{V}
statistic of \eqn{\mathbf{X}}.
}
\details{
This version is with block labels specified.

Dependencies: buildForward, buildReverse, cachePermute, getHammingDistance, getLpDistance
}
