% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary.R
\name{indGaussian}
\alias{indGaussian}
\title{Approximate p-value for Test of Exchangeability (Assuming Large N and P)}
\usage{
indGaussian(X, p = 2)
}
\arguments{
\item{X}{The binary or real matrix on which to perform test of exchangeability}

\item{p}{The power p of \eqn{l_p^p}, i.e., \eqn{||x||_p^p = (x_1^p+...x_n^p)}}
}
\value{
The asymptotic p-value
}
\description{
Computes the large \eqn{(N,P)} asymptotic p-value for dataset \eqn{\mathbf{X}},
assuming its \eqn{P} features are independent
}
\details{
This is the large \eqn{N} and large \eqn{P} asymptotics of the permutation test.

Dependencies: getBinVStat, getRealVStat, getCov, getChi2Weights
}
