% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_scores.R
\name{compute_scores}
\alias{compute_scores}
\title{compute_scores}
\usage{
compute_scores(model0, model1, score_type = "standardized")
}
\arguments{
\item{model0}{a \code{glm} object with the model under the null hypothesis (i.e. the covariates, the nuisance parameters).}

\item{model1}{a \code{glm} or a \code{matrix} (or \code{vector}). If it is a \code{glm} object, it has the model under the alternative hypothesis. The variables in \code{model1} are the same variables in \code{model0} plus one or more variables to be tested.  Alternatively, if
\code{model1} is a \code{matrix}, it contains the tested variables column-wise.}

\item{score_type}{The type of score that is computed. It is "orthogonalized", "effective" or "basic".
"effective" and "orthogonalized" take into account the nuisance estimation.}
}
\description{
Same usage as \code{anova.glm}. 
The parameter \code{id}  is used too, 
if present in \code{model0} (with priority) or in \code{model1}.
}
\examples{
set.seed(1)
Z=rnorm(20)
X=Z+rnorm(20)
Y=rpois(n=20,lambda=exp(Z+X))
mod0=glm(Y~Z,family="poisson")
X=data.frame(X=X)
scr0=compute_scores(model0 = mod0, model1 = X)
head(scr0)
}
\author{
Jesse Hemerik, Riccardo De Santis, Vittorio Giatti, Jelle Goeman and Livio Finos
}
