% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/flowDiv.R
\name{flowDiv}
\alias{flowDiv}
\title{Cytometric Diversity Indices from 'FlowJo' Workspaces}
\usage{
flowDiv(myworkspaces=list(), gate.name=NULL, channel1=NULL,
channel2=NULL, nbins=16, dil=c(), flowrate=c(), volume=c(), nsamples=NULL,
use.beads=FALSE, beads.gate=NULL, doplot=TRUE, file.name=NULL, save.csv=FALSE,
ialpha="invsimpson", ibeta="bray", runalpha="TRUE", runbeta="TRUE")
}
\arguments{
\item{myworkspaces}{A list containing the paths to FlowJo workspaces which are meant to be analyzed. More than one workspace can be analyzed at the same time. Workspaces should contain .fcs files (versions 2.0 or 3.0) with its original names.}

\item{gate.name}{Name of the gate to be analyzed. Must be a single-valued string. The gate should be named exactly the same in all samples from the workspaces.}

\item{channel1}{Name of channel to be plot as y-axis. Channel name should be exactly the same as that assigned by flow cytometer. Note that this is equipment dependent and can vary.}

\item{channel2}{Name of channel to be plot as x-axis. Channel name should be exactly the same as that assigned by flow cytometer. Note that this is equipment dependent and can vary.}

\item{nbins}{Number of bins to cluster each channel. Default=16.}

\item{dil}{A vector containing dilution factors for each sample in the workspaces. Its lenght is the same as the total number of samples meant to be analyzed and must follow the exact same order in which samples are presented to the function (the order of samples corresponds both to the order of workspace described in "myworkspaces" parameter and their order in each of these FlowJo workspaces). By default, it is assumed that all samples have no dilutions whatsoever (i.e. all dilutions factors equal 1).}

\item{flowrate}{A vector containing volumetric flow rate for each sample in the workspaces. Its lenght is the same as the total number of samples meant to be analyzed and must follow the exact same order in which samples are presented to the function (the order of samples corresponds both to the order of workspace described in "myworkspaces" parameter and their order in each of these FlowJo workspaces). Not necessary if "volume" is declared.}

\item{volume}{A vector containing the total liquid volumes (i.e. flow rate x ellapsed time) of each sample in the workspaces. Its lenght is the same as the total number of samples meant to be analyzed and must follow the exact same order in which samples are presented to the function (the order of samples corresponds both to the order of workspace described in "myworkspaces" parameter and their order in each of these FlowJo workspaces). Not necessary if "flowrate" is declared.}

\item{nsamples}{Total number of samples to be analyzed. If there is more than one workspace, that number corresponds to the summation of the samples in each workspace altogether.}

\item{use.beads}{Logical. If “TRUE” , it brings all cytograms to a common point, based on the arithmetic mean of a standard region for all cytograms (usually beads regions), before proceeding to analysis. It is recommended to proceed this way only if samples were analyzed with different settings (i.e. voltages).}

\item{beads.gate}{Name of the gate describing the standard region to be used (usually bead's regions). Necessary only if use.beads is set to “TRUE”. The beads gate should be named exactly the same in all samples from the workspaces.}

\item{doplot}{Logical. It plots scatterplots of gated populations and displays grid lines corresponding to the limits of the bins.}

\item{file.name}{Name of the file in which diversity results should be stored. Required only if save.csv is set to “TRUE”.}

\item{save.csv}{Logical. Used to export diversity results as .csv file.}

\item{ialpha}{Method used to calculate alpha diversity index of cytograms (i.e. the degree of similarity between two cytograms). Should be one of "shannon", "simpson" or "invsimpson", as for vegan::diversity function. Default is "invsimpson".}

\item{ibeta}{Method used to calculate beta diversity index of cytograms. Should be one of  the sixteeen avaiable for vegan::vegdist function. Default is “bray”.}

\item{runalpha}{Logical. Indicates if alpha index should be calculated. Default is “TRUE”.}

\item{runbeta}{Logical. Indicates if beta index should to be calculated. Default is “TRUE”.}
}
\value{
A list containing alpha index, beta matrix and Pielou's indices for each cytogram.
}
\description{
Concatenates some 'flowWorkspace','flowCore' 'vegan' and 'gdata' packages functionalities to import 'FlowJo' workspaces and calculates ecological diversity indices for gated populations, based on bidimensional cytograms. Each detection channel is clustered into “n” bins, resulting in n x n categories, similarly to the methodology proposed by Li (1997) for estimating phytoplankton cytometric diversity. Diversity indices are calculated based on the number of cells per category from each sample.
}
\examples{
\dontrun{

### Using one workspace ###
## Not run:
# Analyzing a .xml FlowJo workspace containg 23 samples using channels FITC-H and SSC-H.

indexes.sw <- flowDiv(myworkspaces = list(“my_flowjo_workspace.xml”),
gate.name = “my_gate_name”, channel1 = “FITC-H”, channel2 = “SSC-H”, nsamples=23)
#assume that the FlowJo workspace is below the current directory

## End (not run)

### Using multiple workspaces ###

## Not run:

indexes.mw <- flowDiv(myworkspaces = list(”my_flowjo_workspace1.wsp”,
“my_flowjo_workspace2.wsp”, “my_flowjo_workspace3.wsp”),
gate.name = ”Bacteria”, channel1 = ”FL1-H”, channel2 = ”SSC-H”, nsamples=36)
#assume that the FlowJo workspaces are below the current directory

## End (not run)
}
}
\author{
Bruno M.S. Wanderley, María Victoria Quiroga, André M. Amado, Fernando Unrein
}
\references{
Li, W.K.W. (1997). Cytometric diversity in marine ultraphytoplankton. Limnology and Oceanography 42, 874–880.
}

