% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_flowmap.R
\name{add_flowmap}
\alias{add_flowmap}
\title{Add a flow map to a ggplot}
\usage{
add_flowmap(
  p,
  flowdat = NULL,
  od = NULL,
  nodes = NULL,
  outline_linewidth = 0.01,
  alpha = 0.8,
  nodes_alpha = 0.8,
  outline_col = "black",
  k_nodes = NULL,
  node_buffer_factor = 1.2,
  node_radius_factor = 1,
  edge_offset_factor = 1,
  node_fill_factor = NULL,
  edge_width_factor = 1.2,
  arrow_point_angle = 45,
  add_legend = "none",
  legend_nudge_x = 0,
  legend_nudge_y = 0,
  legend_col = "gray"
)
}
\arguments{
\item{p}{The plot to which the flowmap should be added.}

\item{flowdat}{Input dataframe. See details below.}

\item{od}{As an alternative to \code{flowdat}, dataframe with the origin-destination pairs and the flow between them.  Must contain the columns o, d, value. \code{nodes} must be provided as well. See details below.}

\item{nodes}{As an alternative to \code{flowdat}, a dataframe with the nodes of the network. Must contain the columns name, x, y. See details below.}

\item{outline_linewidth}{The linewidth of the outline of the arrows.}

\item{alpha}{Opacity of the edges.}

\item{nodes_alpha}{Opacity of the nodes.}

\item{outline_col}{Color of the outline of the edges.}

\item{k_nodes}{Number of clusters to group nodes into. If defined, nodes will be clustered hierarchically based on spatial proximity. By default, no clustering will be applied.}

\item{node_buffer_factor}{Controls the distance between the nodes and the edges ( in multiple of the nodes' radii).}

\item{node_radius_factor}{Controls the size of the nodes.}

\item{edge_offset_factor}{Controls the distance between the parallel arrows.}

\item{node_fill_factor}{Controls the downscaling of the fill of the nodes ( as to not outshine the edges ).}

\item{edge_width_factor}{Controls the width of the edges.}

\item{arrow_point_angle}{Controls the pointiness of the edges.}

\item{add_legend}{Add a legend for width to the plot? Must be one of "none","bottom","top","left", or "right". (Experimental)}

\item{legend_nudge_x}{Adjusts the horizontal position of the legend in map units.}

\item{legend_nudge_y}{Adjusts the vertical position of the legend in map units.}

\item{legend_col}{If \code{add_legend}, controls the color of the legend. Default is grey.}
}
\value{
The ggplot with an additional polygon layer for the flow arrows and an additional polygon layer for the nodes
}
\description{
Add a flow map to a ggplot
}
\details{
The function requires as inputs a dataframe \code{flowdat} which contains for every combination of two nodes a and b the coordinates of these nodes as well as the intensity of flow between those nodes in both directions (a to b, b to a). The dataframe should have the following columns:
\itemize{
\item \strong{id_a:} The unique id of node a
\item \strong{id_b:} The unique id of node b
\item \strong{xa:} The x coordinate of node a
\item \strong{ya:} The y coordinate of node a
\item \strong{xb:} The x coordinate of node b
\item \strong{yb:} The y coordinate of node b
\item \strong{flow_ab:} The intensity of flow from node a to node b
\item \strong{flow_ba:} The intensity of flow from node b to node a
}

Alternatively, the function can take as input a dataframe \code{od} which contains the origin-destination pairs and the flow between them. The dataframe should have the following columns:
\itemize{
\item \strong{o:} The unique id of the origin node
\item \strong{d:} The unique id of the destination node
\item \strong{value:} The intensity of flow between the origin and destination
}
In this case, the function also requires a dataframe \code{nodes} which contains the coordinates of the nodes. The dataframe should have the following columns:
\itemize{
\item \strong{name:} The unique id of the node
\item \strong{x:} The x coordinate of the node
\item \strong{y:} The y coordinate of the node
}

The function will impose coord_equal() on the ggplot.

Inspired by \href{https://flowmap.gl/}{flowmap.gl}.
}
\examples{
testdata <-
data.frame(
 id_a = c("X1","X2","X3","X3","X1"),
 id_b = c("X8","X7","X1","X8","X7"),
 xa = c(2,14,10,10,2),
 ya = c(6,10,9,9,6),
 xb = c(10,4,2,10,4),
 yb = c(4,10,6,4,10),
 flow_ab = c(2,1,1,1,1),
 flow_ba = c(5,1,1,1,2)
)
library(ggplot2)
plot <- ggplot()
plot |> add_flowmap(testdata)
}
\author{
Johannes Mast
}
