% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_pipe_v2.R
\name{run_pipe_v2}
\alias{run_pipe_v2}
\title{Run automated Pipelines}
\usage{
run_pipe_v2(
  pipe_func,
  pipe_src,
  flow_def,
  flow_conf,
  flowname,
  platform,
  flow_run_path = opts_flow$get("flow_run_path"),
  rerun_wd,
  start_from,
  execute = FALSE,
  ...
)
}
\arguments{
\item{pipe_func}{name of the pipeline function in `pipe_src`}

\item{pipe_src}{path to pipeline script}

\item{flow_def}{flow definition file}

\item{flow_conf}{flow conf file with various parameters used by the flow}

\item{flowname}{name for the flow for submission.}

\item{platform}{what platform to use, overrides flowdef}

\item{flow_run_path}{passed onto to_flow. Default it picked up from flowr.conf. Typically this is ~/flowr/runs}

\item{rerun_wd}{if you need to re-run, supply the previous working dir}

\item{start_from}{the step to start a rerun from. Intuitively, this is ignored in a fresh run and only used in re-running a pipeline.}

\item{execute}{TRUE/FALSE}

\item{...}{passed onto the pipeline function as specified in x}
}
\description{
Run complete pipelines, by wrapping several steps into one 
convenient function.

NOTE: please use flowr version 0.9.8.9010 or higher.

In summary, this function performs the following steps:

\itemize{
\item the argument \code{x} defines the name of the pipeline. 
Say, for example \code{sleep_pipe}.
 \item \link{fetch_pipes}: finds the pipeline definition 
 (\code{sleep_pipe.R}, \code{sleep_pipe.def} and
 \code{sleep_pipe.conf} files)
 \item \code{sleep_pipe(\dots)}: Create all the required commands 
 (\code{flowmat})
  \item \link{to_flow}: Use \code{flowmat} and 
  \code{sleep_pipe.def} to create a flow object.
  \item \link{submit_flow}: Submit the flow to the cluster.
}
}
