% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{ffi_compute_fluxes}
\alias{ffi_compute_fluxes}
\title{Compute fluxes for multiple groups (measurements)}
\usage{
ffi_compute_fluxes(
  data,
  group_column,
  time_column,
  gas_column,
  dead_band = 0,
  normalize_time = TRUE,
  fit_function = ffi_fit_models,
  ...
)
}
\arguments{
\item{data}{A \code{\link{data.frame}} (or tibble or data.table)}

\item{group_column}{Name of the grouping column in \code{data}, character;
pass NULL to run with no grouping}

\item{time_column}{Name of the time column in \code{data}, character}

\item{gas_column}{Name of the gas (concentration or quantity) column in
\code{data}, character}

\item{dead_band}{Length of dead band, the equilibration period at the
beginning of the time series during which data are ignore, in seconds (numeric)}

\item{normalize_time}{Normalize the values so that first is zero? Logical}

\item{fit_function}{Optional flux-fit function;
default is \code{\link{ffi_fit_models}}}

\item{...}{Other parameters passed to \code{fit_function}}
}
\value{
A data.frame with one row per \code{group_column} value. It will
always include the mean, minimum, and maximum values of \code{time_column}
for that group, but other
columns depend on what is returned by the \code{fit_function}.
}
\description{
Compute fluxes for multiple groups (measurements)
}
\examples{
# No grouping
ffi_compute_fluxes(cars, group_column = NULL, "speed", "dist")
# With grouping
cars$Plot <- c("A", "B")
ffi_compute_fluxes(cars, "Plot", "speed", "dist")
# See the introductory vignette for a fully-worked example with real data
}
\seealso{
\code{\link{ffi_fit_models}}
}
