% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flux_lrc.R
\name{flux_lrc}
\alias{flux_lrc}
\title{Standardizes CO2 fluxes at fixed PAR values}
\usage{
flux_lrc(
  fluxes_df,
  type_col,
  par_ave = par_ave,
  f_flux = f_flux,
  lrc_arg = "LRC",
  nee_arg = "NEE",
  er_arg = "ER",
  lrc_group = c(),
  par_nee = 300,
  par_er = 0
)
}
\arguments{
\item{fluxes_df}{a dataframe containing NEE, ER and LRC measurements}

\item{type_col}{column containing type of flux (NEE, ER, LRC)}

\item{par_ave}{column containing the PAR value for each flux}

\item{f_flux}{column containing flux values}

\item{lrc_arg}{argument designating LRC fluxes in type column}

\item{nee_arg}{argument designating NEE fluxes in type column}

\item{er_arg}{argument designating ER fluxes in type column}

\item{lrc_group}{character vector of columns to use to group the LRC
(campaign, site, treatment), if applicable}

\item{par_nee}{PAR value to correct the NEE fluxes to}

\item{par_er}{PAR value to correct the ER fluxes to}
}
\value{
the same dataframe with the additional column \code{PAR_corrected_flux}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
Calculates light response curves for CO2 fluxes and
standardizes CO2 fluxes according to the LRC
}
\details{
The light response curves are calculated with a quadratic of the
form
\ifelse{html}{\out{flux(PAR) = a * PAR<sup>2</sup> + b * PAR + c}}{\eqn{flux(PAR) = a * PAR^2 + b * PAR + c}{ASCII}}
}
\examples{
data(co2_fluxes_lrc)
flux_lrc(
fluxes_df = co2_fluxes_lrc,
type_col = type,
par_ave = PAR_ave,
f_flux = f_flux,
lrc_arg = "LRC",
nee_arg = "NEE",
er_arg = "ER",
lrc_group = c("warming"),
par_nee = 300,
par_er = 0
)
}
