% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic-methods.R, R/zero-curve-class.R
\name{interpolate_dfs}
\alias{interpolate_dfs}
\alias{interpolate_fwds}
\alias{interpolate_fwds}
\alias{interpolate_fwds.ZeroCurve}
\alias{interpolate_dfs.ZeroCurve}
\title{Interpolate forward rates and discount factors}
\usage{
interpolate_dfs(x, from, to, ...)

interpolate_fwds(x, from, to, ...)

\method{interpolate_fwds}{ZeroCurve}(x, from, to, ...)

\method{interpolate_dfs}{ZeroCurve}(x, from, to, ...)
}
\arguments{
\item{x}{the object to interpolate}

\item{from}{a \link{Date} vector representing the start of the forward period}

\item{to}{a \link{Date} vector representing the end of the forward period}

\item{...}{further arguments passed to specific methods}
}
\value{
\code{interpolate_dfs} returns a \link[=DiscountFactor]{DiscountFactor} object
of forward discount factors while \code{interpolate_fwds} returns an
\link[=InterestRate]{InterestRate} object of interpolated simply compounded
forward rates.
}
\description{
This interpolates forward rates and forward discount factors from either a
\link[=ZeroCurve]{ZeroCurve} or some other object that contains such an object.
}
\seealso{
Other interpolate functions: \code{\link{interpolate.ZeroCurve}},
  \code{\link{interpolate_zeros}},
  \code{\link{interpolate}}
}
