% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matern.R
\name{fm_gmrf}
\alias{fm_gmrf}
\alias{fm_matern_precision}
\alias{fm_matern_sample}
\alias{fm_covariance}
\alias{fm_sample}
\title{SPDE, GMRF, and Matérn process methods}
\usage{
fm_matern_precision(x, alpha, rho, sigma)

fm_matern_sample(x, alpha = 2, rho, sigma, n = 1, loc = NULL)

fm_covariance(Q, A1 = NULL, A2 = NULL, partial = FALSE)

fm_sample(n, Q, mu = 0, constr = NULL)
}
\arguments{
\item{x}{A mesh object, e.g. from \code{fm_mesh_1d()}, \code{fm_mesh_2d()}, or
other object with supporting \code{\link[=fm_fem]{fm_fem()}} and \code{\link[=fm_manifold_dim]{fm_manifold_dim()}} methods.}

\item{alpha}{The SPDE operator order. The resulting smoothness index
is \code{nu = alpha - dim / 2}. Supports integers 1, 2, 3, etc. that give
\code{nu > 0}.}

\item{rho}{The Matérn range parameter
(scale parameter \code{kappa = sqrt(8 * nu) / rho})}

\item{sigma}{The nominal Matérn std.dev. parameter}

\item{n}{The number of samples to generate}

\item{loc}{locations to evaluate the random field, compatible with
\code{fm_evaluate(x, loc = loc, field = ...)}}

\item{Q}{A precision matrix}

\item{A1, A2}{Matrices, typically obtained from \code{\link[=fm_basis]{fm_basis()}} and/or
\code{\link[=fm_block]{fm_block()}}.}

\item{partial}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} If \code{TRUE}, compute the
partial inverse of \code{Q}, i.e. the elements of the inverse corresponding to
the non-zero pattern of \code{Q}. (Note: This can be done efficiently with
the Takahashi recursion method, but to avoid an RcppEigen dependency this
is currently disabled, and a slower method is used until the efficient method
is reimplemented.)}

\item{mu}{Optional mean vector}

\item{constr}{Optional list of constraint information, with elements
\code{A} and \code{e}. Should only be used for a small number of exact constraints.}
}
\value{
\code{fm_matern_sample()} returns a matrix, where each column is a
sampled field. If \code{loc} is \code{NULL}, the \code{fm_dof(mesh)} basis weights are
given. Otherwise, the evaluated field at the \code{nrow(loc)} locations \code{loc}
are given (from version \verb{0.1.4.9001})
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
Methods for SPDEs and GMRFs.
}
\section{Functions}{
\itemize{
\item \code{fm_matern_precision()}: Construct the (sparse) precision matrix for the basis weights for
Whittle-Matérn SPDE models.  The boundary behaviour is determined by the
provided mesh function space.

\item \code{fm_matern_sample()}: Simulate a Matérn field given a mesh and
covariance function parameters, and optionally evaluate at given locations.

\item \code{fm_covariance()}: Compute the covariance between "A1 x" and "A2 x", when
x is a basis vector with precision matrix \code{Q}.

\item \code{fm_sample()}: Generate \code{n} samples based on a sparse precision matrix \code{Q}

}}
\examples{
library(Matrix)
mesh <- fm_mesh_1d(-20:120, degree = 2)
Q <- fm_matern_precision(mesh, alpha = 2, rho = 15, sigma = 1)
x <- seq(0, 100, length.out = 601)
A <- fm_basis(mesh, x)
plot(x,
  as.vector(Matrix::diag(fm_covariance(Q, A))),
  type = "l",
  ylab = "marginal variances"
)

plot(x,
  fm_evaluate(mesh, loc = x, field = fm_sample(1, Q)[, 1]),
  type = "l",
  ylab = "process sample"
)

}
