% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/holdings.R
\name{fmpc_13f_data}
\alias{fmpc_13f_data}
\title{13F data for a set of ciks and dates}
\usage{
fmpc_13f_data(cik = "0001067983", date = "2019-12-31")
}
\arguments{
\item{cik}{one or more valid ciks from \code{\link{fmpc_13f_cik_list}}}

\item{date}{one or more quarter end dates (yyyy-03-31, yyyy-06-30,
yyyy-09-30, yyyy-12-31)}
}
\value{
13F holdings
}
\description{
13F shows the holdings of an asset manager as of a specific date
}
\examples{



\dontrun{

# Berkshire can be run using the demo
fmpc_set_token()
fmpc_13f_data('0001067983', '2020-03-31')

# Must set a valid API token
fmpc_set_token('FMPAPIKEY')
goldmanCik = fmpc_13f_cik_search('golman')
fmpc_13f_data(cik = goldmanCik$cik, date = c('2020-03-31','2020-06-30'))

}
}
