% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/AllMethods.R
\docType{methods}
\name{fmrs.mle}
\alias{fmrs.mle}
\alias{fmrs.mle,ANY-method}
\alias{fmrs.mle-method}
\title{fmrs.mle method}
\usage{
fmrs.mle(y, delta, x, nComp, ...)

\S4method{fmrs.mle}{ANY}(y, delta, x, nComp = 2, disFamily = "lnorm",
  initCoeff, initDispersion, initmixProp, lambRidge = 0, nIterEM = 400,
  nIterNR = 2, conveps = 1e-08, convepsEM = 1e-08, convepsNR = 1e-08,
  porNR = 2, activeset)
}
\arguments{
\item{y}{Responses (observations)}

\item{delta}{Censoring indicator vector}

\item{x}{Design matrix (covariates)}

\item{nComp}{Order (Number of components) of mixture model}

\item{...}{Other possible options}

\item{disFamily}{A sub-distribution family. The options
are \code{"norm"} for \code{FMR} models, \code{"lnorm"} for mixture of AFT
regression models with Log-Normal sub-distributions,\code{"weibull"}
for mixture of AFT regression models with Weibull sub-distributions}

\item{initCoeff}{Vector of initial values for regression coefficients
including intercepts}

\item{initDispersion}{Vector of initial values for standard deviations}

\item{initmixProp}{Vector of initial values for proportion of components}

\item{lambRidge}{A positive value for tuning parameter in Ridge
Regression or Elastic Net}

\item{nIterEM}{Maximum number of iterations for EM algorithm}

\item{nIterNR}{Maximum number of iterations for Newton-Raphson algorithm}

\item{conveps}{A positive value for avoiding NaN in computing divisions}

\item{convepsEM}{A positive value for threshold of convergence in
EM algorithm}

\item{convepsNR}{A positive value for threshold of convergence in
Newton-Raphson algorithm}

\item{porNR}{A positive integer for maximum number of searches in
NR algorithm}

\item{activeset}{A matrix of zero-one that shows which intercepts and
covariates are active in the fitted fmrs model}
}
\value{
An \code{\link{fmrsfit-class}} that includes parameter
    estimates of the specified \code{FMRs} model
}
\description{
Provides MLE for Finite Mixture of
    Accelerated Failure Time Regression Models or Finite Mixture of
    Regression Models. It also provides Ridge Regression.
}
\details{
Finite mixture of AFT regression models are represented as
    follows. Let \eqn{X} be the survival time with non-negative values,
    and \eqn{\boldsymbol{z} =(z_{1}, \ldots, z_{d})^{\top}}
    be a \eqn{d}-dimensional vector of covariates that may have an effect
    on \eqn{X}.
    If the survival time is subject to right censoring, then the observed
    response time is \eqn{T=\min \{Y, C\}},
    where \eqn{Y=\log X}, \eqn{C} is  logarithm of  the censoring time
    and \eqn{\delta=I_{\{y<c\}}} is the censoring indicator.
    We say that \eqn{V=(T,\delta,\boldsymbol z)} follows a finite mixture
    of AFT regression models of order \eqn{K} if the
    conditional density of \eqn{(T,\delta)} given \eqn{\boldsymbol z}
    has the form \deqn{f(t,\delta;\boldsymbol{z},\boldsymbol\Psi)
    =\sum\limits_{k=1}^{K}\pi_{k}[f_Y(t;\theta_{k}(\boldsymbol z),
    \sigma_{k})]^{\delta}[S_Y(t;\theta_{k}(\boldsymbol z)
    ,\sigma_{k})]^{1-\delta}[f_{C}(t)]^{1-\delta}[S_{C}(t)]^{\delta}}
    where \eqn{f_Y(.)} and \eqn{S_Y(.)} are respectively the density and
    survival functions of \eqn{Y}, \eqn{f_C(.)} and \eqn{S_C(.)} are
    respectively the density and survival functions of \eqn{C}; and
    \eqn{{\theta}_{k}(\boldsymbol{z})=h(\beta_{0k}+\boldsymbol{z}^{\top}
    \boldsymbol\beta_{k})} for a known link function \eqn{h(.)},
    \eqn{\boldsymbol\Psi=(\pi_{1},\ldots,\pi_{K},\beta_{01},\ldots,
    \beta_{0K},\boldsymbol\beta_{1},
    \ldots,\boldsymbol\beta_{K},\sigma_{1},
    \ldots,\sigma_{K})^{\top}} with \eqn{\boldsymbol\beta_{k}=
    (\beta_{k1},\beta_{k2},\ldots,\beta_{kd})^{\top}}
    and \eqn{0<\pi_{k}<1}
    with \eqn{\sum_{k=1}^{K}\pi_{k}=1}.
    The log-likelihood of a sample of size $n$ is formed
    as \deqn{\ell_{n}(\boldsymbol\Psi) =
    \sum\limits_{i=1}^{n}\log\sum\limits_{k=1}^{K}\pi_{k}\left[f_Y(t_{i},
    \theta_{k}({\boldsymbol z}_{i}),\sigma_{k})  \right]^{\delta_{i}}
    \left[S_Y(t_{i},\theta_{k}({\boldsymbol z}_{i}),
    \sigma_{k})\right]^{1-\delta_{i}}.}
    Note that we assume the censoring distribution is non-informative and
    hence won't play any role in the estimation process. We use EM and
    Newton-Raphson algorithms in our method to find the maximizer of
    above Log-Likelihood.
}
\examples{
set.seed(1980)
nComp = 2
nCov = 10
nObs = 500
dispersion = c(1, 1)
mixProp = c(0.4, 0.6)
rho = 0.5
coeff1 = c( 2,  2, -1, -2, 1, 2, 0, 0,  0, 0,  0)
coeff2 = c(-1, -1,  1,  2, 0, 0, 0, 0, -1, 2, -2)
umax = 40

dat <- fmrs.gendata(nObs = nObs, nComp = nComp, nCov = nCov,
                     coeff = c(coeff1, coeff2), dispersion = dispersion,
                     mixProp = mixProp, rho = rho, umax = umax,
                     disFamily = "lnorm")

res.mle <- fmrs.mle(y = dat$y, x = dat$x, delta = dat$delta,
                    nComp = nComp, disFamily = "lnorm",
                    initCoeff = rnorm(nComp*nCov+nComp),
                    initDispersion = rep(1, nComp),
                    initmixProp = rep(1/nComp, nComp))
summary(res.mle)
}
\author{
Farhad Shokoohi <shokoohi@icloud.com>
}
\references{
Shokoohi, F., Khalili, A., Asgharian, M. and Lin, S.
    (2016 submitted) Variable Selection in Mixture of Survival Models for
    Biomedical Genomic Studies
}
\seealso{
Other lnorm..norm..weibull: \code{\link{fmrs.gendata}},
  \code{\link{fmrs.tunsel}}, \code{\link{fmrs.varsel}}
}
\concept{
fmr, aft, mle, ridge, fmrs
}
\keyword{AFT}
\keyword{Censored}
\keyword{EM}
\keyword{FMRs}
\keyword{NR}
\keyword{Ridge}

