\name{VIF}
\alias{VIF}
\title{Calculate variance inflation factor (VIF) from the result of lm.}
\description{To evaluate multicolinearity of multiple regression model, calculating the variance inflation factor (VIF) from the result of lm().  If VIF is more than 10, multicolinearity is strongly suggested.}
\usage{VIF(X)}
\arguments{
 \item{X}{The object with class "lm", which would be generated by lm().}
}
\value{
 A variance inflation factor is returned.
}
\author{Minato Nakazawa \email{minato-nakazawa@umin.net} \url{http://minato.sip21c.org/}}
\examples{
 # the target multiple regression model
 res <- lm(Ozone ~ Wind+Temp+Solar.R, data=airquality)
 summary(res)
 # checking multicolinearity for independent variables.
 VIF(lm(Wind ~ Temp+Solar.R, data=airquality))
 VIF(lm(Temp ~ Wind+Solar.R, data=airquality))
 VIF(lm(Solar.R ~ Wind+Temp, data=airquality))
}
